/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#include "sfx2/sfxcommands.h"
#include "svx/svxcommands.h"
#include "sccommands.h"

#define HID_INSWIN_POS                                          "SC_HID_INSWIN_POS"
#define HID_INSWIN_CALC                                         "SC_HID_INSWIN_CALC"
#define HID_INSWIN_CANCEL                                       "SC_HID_INSWIN_CANCEL"
#define HID_INSWIN_OK                                           "SC_HID_INSWIN_OK"
#define HID_INSWIN_SUMME                                        "SC_HID_INSWIN_SUMME"
#define HID_INSWIN_FUNC                                         "SC_HID_INSWIN_FUNC"
#define HID_INSWIN_INPUT                                        "SC_HID_INSWIN_INPUT"

// Hilfe IDs fuer Dokumentfenster --------------------------------------------
#define HID_SC_WIN_GRIDWIN                                      "SC_HID_SC_WIN_GRIDWIN"
#define HID_SC_WIN_PREVIEW                                      "SC_HID_SC_WIN_PREVIEW"

// Hilfe IDs fuer einzelne Controls (max.30) ---------------------------------
//  Kopf/Fusszeilen Editfenster: Header/Footer links/rechts links/mitte/rechts
#define HID_SC_HF_HLL                                           "SC_HID_SC_HF_HLL"
#define HID_SC_HF_HLC                                           "SC_HID_SC_HF_HLC"
#define HID_SC_HF_HLR                                           "SC_HID_SC_HF_HLR"
#define HID_SC_HF_HRL                                           "SC_HID_SC_HF_HRL"
#define HID_SC_HF_HRC                                           "SC_HID_SC_HF_HRC"
#define HID_SC_HF_HRR                                           "SC_HID_SC_HF_HRR"
#define HID_SC_HF_FLL                                           "SC_HID_SC_HF_FLL"
#define HID_SC_HF_FLC                                           "SC_HID_SC_HF_FLC"
#define HID_SC_HF_FLR                                           "SC_HID_SC_HF_FLR"
#define HID_SC_HF_FRL                                           "SC_HID_SC_HF_FRL"
#define HID_SC_HF_FRC                                           "SC_HID_SC_HF_FRC"
#define HID_SC_HF_FRR                                           "SC_HID_SC_HF_FRR"
//  "Spalten" in Teilergebnissen: Gruppe 1/2/3 - nicht mehr!
#define HID_SC_SUBT_COLS_1                                      "SC_HID_SC_SUBT_COLS_1"
#define HID_SC_SUBT_COLS_2                                      "SC_HID_SC_SUBT_COLS_2"
#define HID_SC_SUBT_COLS_3                                      "SC_HID_SC_SUBT_COLS_3"
//  Eintraege im Navigator
#define HID_SC_NAVIPI_ENTRIES                                   "SC_HID_SC_NAVIPI_ENTRIES"
#define HID_SC_NAVIPI_ROW                                       "SC_HID_SC_NAVIPI_ROW"
#define HID_SC_NAVIPI_COL                                       "SC_HID_SC_NAVIPI_COL"
#define HID_SC_NAVIPI_DOC                                       "SC_HID_SC_NAVIPI_DOC"
#define HID_SC_NAVIPI_DATA                                      "SC_HID_SC_NAVIPI_DATA"
#define HID_SC_NAVIPI_UP                                        "SC_HID_SC_NAVIPI_UP"
#define HID_SC_NAVIPI_DOWN                                      "SC_HID_SC_NAVIPI_DOWN"
#define HID_SC_NAVIPI_ZOOM                                      "SC_HID_SC_NAVIPI_ZOOM"
#define HID_SC_NAVIPI_ROOT                                      "SC_HID_SC_NAVIPI_ROOT"
#define HID_SC_NAVIPI_SCEN                                      "SC_HID_SC_NAVIPI_SCEN"
#define HID_SC_NAVIPI_DROP                                      "SC_HID_SC_NAVIPI_DROP"
//  Teilergebnisse
#define HID_SC_SUBT_GROUP                                       "SC_HID_SC_SUBT_GROUP"
#define HID_SC_SUBT_COLS                                        "SC_HID_SC_SUBT_COLS"
#define HID_SC_SUBT_FUNC                                        "SC_HID_SC_SUBT_FUNC"
//
#define HID_SC_NAVIPI_TOOLBOX                                   "SC_HID_SC_NAVIPI_TOOLBOX"
//  Bereich ist voll!

// Hilfe IDs fuer Dialoge / Pages (max.70) -----------------------------------
#define HID_SC_AUTOFORMAT                                       "SC_HID_SC_AUTOFORMAT"
#define HID_SC_PIVOTFILTER                                      "SC_HID_SC_PIVOTFILTER"
#define HID_SC_INPORTOPT                                        "SC_HID_SC_INPORTOPT"
#define HID_SC_PIVOTSUBT                                        "SC_HID_SC_PIVOTSUBT"
#define HID_SC_FORM_ARGS                                        "SC_HID_SC_FORM_ARGS"
#define HID_SCPAGE_SORT_FIELDS                                  "SC_HID_SCPAGE_SORT_FIELDS"
#define HID_SCPAGE_SORT_OPTIONS                                 "SC_HID_SCPAGE_SORT_OPTIONS"
#define HID_SCPAGE_SUBT_OPTIONS                                 "SC_HID_SCPAGE_SUBT_OPTIONS"
#define HID_SCPAGE_SUBT_GROUP                                   "SC_HID_SCPAGE_SUBT_GROUP"
#define HID_SCPAGE_PROTECTION                                   "SC_HID_SCPAGE_PROTECTION"
#define HID_SCPAGE_VIEW                                         "SC_HID_SCPAGE_VIEW"
#define HID_SCPAGE_CALC                                         "SC_HID_SCPAGE_CALC"
#define HID_SCPAGE_FORMULA                                      "SC_HID_SCPAGE_FORMULA"
#define HID_SCPAGE_USERLISTS                                    "SC_HID_SCPAGE_USERLISTS"
#define HID_SCPAGE_HFEDIT                                       "SC_HID_SCPAGE_HFEDIT"
#define HID_SCPAGE_AREAS                                        "SC_HID_SCPAGE_AREAS"
#define HID_SCPAGE_COMPATIBILITY                                "SC_HID_SCPAGE_COMPATIBILITY"
#define HID_SCPAGE_TABLE                                        "SC_HID_SCPAGE_TABLE"
#define HID_SCPAGE_PRINT                                        "SC_HID_SCPAGE_PRINT"
#define HID_SCPAGE_DEFAULTS                                     "SC_HID_SCPAGE_DEFAULTS"
#define HID_SCPAGE_SUBT_GROUP1                                  "SC_HID_SCPAGE_SUBT_GROUP1"
#define HID_SCPAGE_SUBT_GROUP2                                  "SC_HID_SCPAGE_SUBT_GROUP2"
#define HID_SCPAGE_SUBT_GROUP3                                  "SC_HID_SCPAGE_SUBT_GROUP3"

#define HID_SCPAGE_HFED_HL                                      "SC_HID_SCPAGE_HFED_HL"
#define HID_SCPAGE_HFED_HR                                      "SC_HID_SCPAGE_HFED_HR"
#define HID_SCPAGE_HFED_FL                                      "SC_HID_SCPAGE_HFED_FL"
#define HID_SCPAGE_HFED_FR                                      "SC_HID_SCPAGE_HFED_FR"

#define HID_SCPAGE_CONTENT                                      "SC_HID_SCPAGE_CONTENT"
#define HID_SCPAGE_LAYOUT                                       "SC_HID_SCPAGE_LAYOUT"
#define HID_SCPAGE_INPUT                                        "SC_HID_SCPAGE_INPUT"

#define HID_SC_NAVIGATOR                                        "SC_HID_SC_NAVIGATOR"

#define HID_SC_MTRIN_VAL                                        "SC_HID_SC_MTRIN_VAL"
#define HID_SC_MTRIN_DEF                                        "SC_HID_SC_MTRIN_DEF"
#define HID_SC_SELENTRY_LIST                                    "SC_HID_SC_SELENTRY_LIST"
#define HID_SC_GROUP_COLS                                       "SC_HID_SC_GROUP_COLS"
#define HID_SC_GROUP_ROWS                                       "SC_HID_SC_GROUP_ROWS"

#define HID_SC_HF_TEXT                                          "SC_HID_SC_HF_TEXT"
#define HID_SC_HF_FILE                                          "SC_HID_SC_HF_FILE"
#define HID_SC_HF_TABLE                                         "SC_HID_SC_HF_TABLE"
#define HID_SC_HF_PAGE                                          "SC_HID_SC_HF_PAGE"
#define HID_SC_HF_PAGES                                         "SC_HID_SC_HF_PAGES"
#define HID_SC_HF_DATE                                          "SC_HID_SC_HF_DATE"
#define HID_SC_HF_TIME                                          "SC_HID_SC_HF_TIME"

#define HID_SC_HEADER_EDIT                                      "SC_HID_SC_HEADER_EDIT"
#define HID_SC_FOOTER_EDIT                                      "SC_HID_SC_FOOTER_EDIT"

#define HID_SC_SCENWIN_TOP                                      "SC_HID_SC_SCENWIN_TOP"
#define HID_SC_SCENWIN_BOTTOM                                   "SC_HID_SC_SCENWIN_BOTTOM"

#define HID_SC_INPUTWIN                                         "SC_HID_SC_INPUTWIN"

#define HID_SC_RENAME_NAME                                      "SC_HID_SC_RENAME_NAME"
#define HID_SC_APPEND_NAME                                      "SC_HID_SC_APPEND_NAME"

//  Funktionsautopilot: nur als Unique-IDs
#define HID_SC_FAP_PAGE                                         "SC_HID_SC_FAP_PAGE"
#define HID_SC_FAP_EDIT1                                        "SC_HID_SC_FAP_EDIT1"
#define HID_SC_FAP_EDIT2                                        "SC_HID_SC_FAP_EDIT2"
#define HID_SC_FAP_EDIT3                                        "SC_HID_SC_FAP_EDIT3"
#define HID_SC_FAP_EDIT4                                        "SC_HID_SC_FAP_EDIT4"

#define HID_SC_ADD_AUTOFMT                                      "SC_HID_SC_ADD_AUTOFMT"
#define HID_SC_AUTOFMT_NAME                                     "SC_HID_SC_AUTOFMT_NAME"

#define HID_SC_DROPMODE_URL                                     "SC_HID_SC_DROPMODE_URL"
#define HID_SC_DROPMODE_LINK                                    "SC_HID_SC_DROPMODE_LINK"
#define HID_SC_DROPMODE_COPY                                    "SC_HID_SC_DROPMODE_COPY"

#define HID_SC_FAP_STRUCT                                       "SC_HID_SC_FAP_STRUCT"
#define HID_SC_ASCII_TABCTR                                     "SC_HID_SC_ASCII_TABCTR"

#define HID_SC_SCENARIO_DELETE                                  "SC_HID_SC_SCENARIO_DELETE"
#define HID_SC_SCENARIO_EDIT                                    "SC_HID_SC_SCENARIO_EDIT"

#define HID_SCDLG_FORMULA                                       "SC_HID_SCDLG_FORMULA"
#define HID_SCDLG_CONDFORMAT                                    "SC_HID_SCDLG_CONDFORMAT"
#define HID_COLROWNAMERANGES                                    "SC_HID_COLROWNAMERANGES"

#define HID_FUNCTION_BOX                                        "SC_HID_FUNCTION_BOX"
#define HID_SCPAGE_OPREDLINE                                    "SC_HID_SCPAGE_OPREDLINE"
#define HID_SC_REDLIN_CTR                                       "SC_HID_SC_REDLIN_CTR"

//Kopf/FusszeilenDlg: Contextmenue fuer Dateiname
#define HID_FCOMMAND_TITEL                                      "SC_HID_FCOMMAND_TITEL"
#define HID_FCOMMAND_FILENAME                                   "SC_HID_FCOMMAND_FILENAME"
#define HID_FCOMMAND_PATH                                       "SC_HID_FCOMMAND_PATH"


// Hilfe IDs fuer Objekt- und Werkzeugleisten (max.10) -----------------------

#define HID_SC_TOOLBOX_TOOLS                                    "SC_HID_SC_TOOLBOX_TOOLS"
#define HID_SC_TOOLBOX_TABLE                                    "SC_HID_SC_TOOLBOX_TABLE"
#define HID_SC_TOOLBOX_DRAW                                     "SC_HID_SC_TOOLBOX_DRAW"
#define HID_SC_TOOLBOX_DRTEXT                                   "SC_HID_SC_TOOLBOX_DRTEXT"
#define HID_SC_TOOLBOX_PREVIEW                                  "SC_HID_SC_TOOLBOX_PREVIEW"

//  wrong group - HID_SC_DLG_START is full
#define HID_SC_RENAME_AUTOFMT                                   "SC_HID_SC_RENAME_AUTOFMT"
#define HID_SC_REN_AFMT_NAME                                    "SC_HID_SC_REN_AFMT_NAME"

#define HID_SC_TOOLBOX_GRAPHIC                                  "SC_HID_SC_TOOLBOX_GRAPHIC"

#define HID_CHG_PROTECT                                         "SC_HID_CHG_PROTECT"

#define HID_SC_RENAME_OBJECT                                    "SC_HID_SC_RENAME_OBJECT"

#define HID_SC_REN_AFMT_DLG                                     "SC_HID_SC_REN_AFMT_DLG"

// Hilfe IDs fuer Submenus (max.50) ------------------------------------------
#define HID_SCMENU_EDIT                                         "SC_HID_SCMENU_EDIT"
#define HID_SCMENU_FILL                                         "SC_HID_SCMENU_FILL"
#define HID_SCMENU_DELBREAK                                     "SC_HID_SCMENU_DELBREAK"
#define HID_SCMENU_VIEW                                         "SC_HID_SCMENU_VIEW"
#define HID_SCMENU_TOOLBARS                                     "SC_HID_SCMENU_TOOLBARS"
#define HID_SCMENU_INSERT                                       "SC_HID_SCMENU_INSERT"
#define HID_SCMENU_INSBREAK                                     "SC_HID_SCMENU_INSBREAK"
#define HID_SCMENU_NAME                                         "SC_HID_SCMENU_NAME"
#define HID_SCMENU_GRAPHIC                                      "SC_HID_SCMENU_GRAPHIC"
#define HID_SCMENU_DATA                                         "SC_HID_SCMENU_DATA"
#define HID_SCMENU_FILTER                                       "SC_HID_SCMENU_FILTER"
#define HID_SCMENU_OUTLINE                                      "SC_HID_SCMENU_OUTLINE"
#define HID_SCMENU_PIVOT                                        "SC_HID_SCMENU_PIVOT"
#define HID_SCMENU_EXTRA                                        "SC_HID_SCMENU_EXTRA"
#define HID_SCMENU_SPELLING                                     "SC_HID_SCMENU_SPELLING"
#define HID_SCMENU_AUDIT                                        "SC_HID_SCMENU_AUDIT"
#define HID_SCMENU_PROTECT                                      "SC_HID_SCMENU_PROTECT"
#define HID_SCMENU_CELLCONT                                     "SC_HID_SCMENU_CELLCONT"
#define HID_SCMENU_ROW                                          "SC_HID_SCMENU_ROW"
#define HID_SCMENU_COL                                          "SC_HID_SCMENU_COL"
#define HID_SCMENU_TAB                                          "SC_HID_SCMENU_TAB"
#define HID_SCMENU_MERGE                                        "SC_HID_SCMENU_MERGE"
#define HID_SCMENU_AREA                                         "SC_HID_SCMENU_AREA"
#define HID_SCMENU_OBJMIRROR                                    "SC_HID_SCMENU_OBJMIRROR"
#define HID_SCMENU_OBJARRANGE                                   "SC_HID_SCMENU_OBJARRANGE"
#define HID_SCMENU_ANCHOR                                       "SC_HID_SCMENU_ANCHOR"
#define HID_SCMENU_SENDTO                                       "SC_HID_SCMENU_SENDTO"
#define HID_SCMENU_CHANGES                                      "SC_HID_SCMENU_CHANGES"

#define HID_SC_FAP_BTN_FX1                                      "SC_HID_SC_FAP_BTN_FX1"
#define HID_SC_FAP_BTN_FX2                                      "SC_HID_SC_FAP_BTN_FX2"
#define HID_SC_FAP_BTN_FX3                                      "SC_HID_SC_FAP_BTN_FX3"
#define HID_SC_FAP_BTN_FX4                                      "SC_HID_SC_FAP_BTN_FX4"
#define HID_SC_FAP_BTN_REF1                                     "SC_HID_SC_FAP_BTN_REF1"
#define HID_SC_FAP_BTN_REF2                                     "SC_HID_SC_FAP_BTN_REF2"
#define HID_SC_FAP_BTN_REF3                                     "SC_HID_SC_FAP_BTN_REF3"
#define HID_SC_FAP_BTN_REF4                                     "SC_HID_SC_FAP_BTN_REF4"
#define HID_SC_FAP_FORMULA                                      "SC_HID_SC_FAP_FORMULA"

#define HID_SC_SORT_ACTION                                      "SC_HID_SC_SORT_ACTION"
#define HID_SC_SORT_AUTHOR                                      "SC_HID_SC_SORT_AUTHOR"
#define HID_SC_SORT_DATE                                        "SC_HID_SC_SORT_DATE"
#define HID_SC_SORT_COMMENT                                     "SC_HID_SC_SORT_COMMENT"
#define HID_SORT_POSITION                                       "SC_HID_SORT_POSITION"
#define HID_SC_CHANGES_COMMENT                                  "SC_HID_SC_CHANGES_COMMENT"
#define HID_SC_FUNCTIONLIST                                     "SC_HID_SC_FUNCTIONLIST"
#define HID_SCPAGE_OPTLOAD                                      "SC_HID_SCPAGE_OPTLOAD"
#define HID_PASSWD_TABLE                                        "SC_HID_PASSWD_TABLE"
#define HID_PASSWD_DOC                                          "SC_HID_PASSWD_DOC"

#define HID_DATAPILOT_TYPE                                      "SC_HID_DATAPILOT_TYPE"
#define HID_DATAPILOT_DATABASE                                  "SC_HID_DATAPILOT_DATABASE"
#define HID_DATAPILOT_SERVICE                                   "SC_HID_DATAPILOT_SERVICE"

// Other help IDs (max.70) ---------------------------------------------------
#define HID_SCDLG_LINKAREAURL                                   "SC_HID_SCDLG_LINKAREAURL"
#define HID_SCMENU_EDIT_TABLE                                   "SC_HID_SCMENU_EDIT_TABLE"

#define HID_SELECTTABLES                                        "SC_HID_SELECTTABLES"
#define HID_SC_REPLCELLSWARN                                    "SC_HID_SC_REPLCELLSWARN"

// data pilot layout dialog
#define HID_SC_DPLAY_PAGE                                       "SC_HID_SC_DPLAY_PAGE"
#define HID_SC_DPLAY_COLUMN                                     "SC_HID_SC_DPLAY_COLUMN"
#define HID_SC_DPLAY_ROW                                        "SC_HID_SC_DPLAY_ROW"
#define HID_SC_DPLAY_DATA                                       "SC_HID_SC_DPLAY_DATA"
#define HID_SC_DPLAY_SELECT                                     "SC_HID_SC_DPLAY_SELECT"

#define HID_SC_DRAW_RENAME                                      "SC_HID_SC_DRAW_RENAME"

#define HID_SC_DPDATAFIELD                                      "SC_HID_SC_DPDATAFIELD"
#define HID_SC_DPSUBT_OPT                                       "SC_HID_SC_DPSUBT_OPT"
#define HID_SC_DPSUBT_HIDE                                      "SC_HID_SC_DPSUBT_HIDE"
#define HID_SC_DPNUMGROUP                                       "SC_HID_SC_DPNUMGROUP"
#define HID_SC_DPDATEGROUP                                      "SC_HID_SC_DPDATEGROUP"
#define HID_SC_DPDATEGROUP_LB                                   "SC_HID_SC_DPDATEGROUP_LB"
#define HID_SC_DPSHOWDETAIL                                     "SC_HID_SC_DPSHOWDETAIL"

// #i68101#
#define HID_SC_TITLE_DESCRIPTION_OBJECT                         "SC_HID_SC_TITLE_DESCRIPTION_OBJECT"

#define HID_SC_SOLVEROPTIONS                                    "SC_HID_SC_SOLVEROPTIONS"
#define HID_SC_SOLVEROPTIONS_LB                                 "SC_HID_SC_SOLVEROPTIONS_LB"
#define HID_SC_SOLVER_INTEGER                                   "SC_HID_SC_SOLVER_INTEGER"
#define HID_SC_SOLVER_DOUBLE                                    "SC_HID_SC_SOLVER_DOUBLE"
#define HID_SC_SOLVER_PROGRESS                                  "SC_HID_SC_SOLVER_PROGRESS"
#define HID_SC_SOLVER_NOSOLUTION                                "SC_HID_SC_SOLVER_NOSOLUTION"
#define HID_SC_SOLVER_SUCCESS                                   "SC_HID_SC_SOLVER_SUCCESS"

#define HID_SCDLG_CONFLICTS                                     "SC_HID_SCDLG_CONFLICTS"

#define HID_SC_HF_HL_DEFINED                                    "SC_HID_SC_HF_HL_DEFINED"
#define HID_SC_HF_HR_DEFINED                                    "SC_HID_SC_HF_HR_DEFINED"
#define HID_SC_HF_FL_DEFINED                                    "SC_HID_SC_HF_FL_DEFINED"
#define HID_SC_HF_FR_DEFINED                                    "SC_HID_SC_HF_FR_DEFINED"

// Analysis Addin Functions (max.120) ----------------------------------------
#define HID_AAI_FUNC_WORKDAY                                    "SC_HID_AAI_FUNC_WORKDAY"
#define HID_AAI_FUNC_YEARFRAC                                   "SC_HID_AAI_FUNC_YEARFRAC"
#define HID_AAI_FUNC_EDATE                                      "SC_HID_AAI_FUNC_EDATE"
#define HID_AAI_FUNC_WEEKNUM                                    "SC_HID_AAI_FUNC_WEEKNUM"
#define HID_AAI_FUNC_EOMONTH                                    "SC_HID_AAI_FUNC_EOMONTH"
#define HID_AAI_FUNC_NETWORKDAYS                                "SC_HID_AAI_FUNC_NETWORKDAYS"
#define HID_AAI_FUNC_AMORDEGRC                                  "SC_HID_AAI_FUNC_AMORDEGRC"
#define HID_AAI_FUNC_AMORLINC                                   "SC_HID_AAI_FUNC_AMORLINC"
#define HID_AAI_FUNC_ACCRINT                                    "SC_HID_AAI_FUNC_ACCRINT"
#define HID_AAI_FUNC_ACCRINTM                                   "SC_HID_AAI_FUNC_ACCRINTM"
#define HID_AAI_FUNC_RECEIVED                                   "SC_HID_AAI_FUNC_RECEIVED"
#define HID_AAI_FUNC_DISC                                       "SC_HID_AAI_FUNC_DISC"
#define HID_AAI_FUNC_DURATION                                   "SC_HID_AAI_FUNC_DURATION"
#define HID_AAI_FUNC_EFFECT                                     "SC_HID_AAI_FUNC_EFFECT"
#define HID_AAI_FUNC_CUMPRINC                                   "SC_HID_AAI_FUNC_CUMPRINC"
#define HID_AAI_FUNC_CUMIPMT                                    "SC_HID_AAI_FUNC_CUMIPMT"
#define HID_AAI_FUNC_PRICE                                      "SC_HID_AAI_FUNC_PRICE"
#define HID_AAI_FUNC_PRICEDISC                                  "SC_HID_AAI_FUNC_PRICEDISC"
#define HID_AAI_FUNC_PRICEMAT                                   "SC_HID_AAI_FUNC_PRICEMAT"
#define HID_AAI_FUNC_MDURATION                                  "SC_HID_AAI_FUNC_MDURATION"
#define HID_AAI_FUNC_NOMINAL                                    "SC_HID_AAI_FUNC_NOMINAL"
#define HID_AAI_FUNC_DOLLARFR                                   "SC_HID_AAI_FUNC_DOLLARFR"
#define HID_AAI_FUNC_DOLLARDE                                   "SC_HID_AAI_FUNC_DOLLARDE"
#define HID_AAI_FUNC_YIELD                                      "SC_HID_AAI_FUNC_YIELD"
#define HID_AAI_FUNC_YIELDDISC                                  "SC_HID_AAI_FUNC_YIELDDISC"
#define HID_AAI_FUNC_YIELDMAT                                   "SC_HID_AAI_FUNC_YIELDMAT"
#define HID_AAI_FUNC_TBILLEQ                                    "SC_HID_AAI_FUNC_TBILLEQ"
#define HID_AAI_FUNC_TBILLPRICE                                 "SC_HID_AAI_FUNC_TBILLPRICE"
#define HID_AAI_FUNC_TBILLYIELD                                 "SC_HID_AAI_FUNC_TBILLYIELD"
#define HID_AAI_FUNC_ODDFPRICE                                  "SC_HID_AAI_FUNC_ODDFPRICE"
#define HID_AAI_FUNC_ODDFYIELD                                  "SC_HID_AAI_FUNC_ODDFYIELD"
#define HID_AAI_FUNC_ODDLPRICE                                  "SC_HID_AAI_FUNC_ODDLPRICE"
#define HID_AAI_FUNC_ODDLYIELD                                  "SC_HID_AAI_FUNC_ODDLYIELD"
#define HID_AAI_FUNC_XIRR                                       "SC_HID_AAI_FUNC_XIRR"
#define HID_AAI_FUNC_XNPV                                       "SC_HID_AAI_FUNC_XNPV"
#define HID_AAI_FUNC_INTRATE                                    "SC_HID_AAI_FUNC_INTRATE"
#define HID_AAI_FUNC_COUPNCD                                    "SC_HID_AAI_FUNC_COUPNCD"
#define HID_AAI_FUNC_COUPDAYS                                   "SC_HID_AAI_FUNC_COUPDAYS"
#define HID_AAI_FUNC_COUPDAYSNC                                 "SC_HID_AAI_FUNC_COUPDAYSNC"
#define HID_AAI_FUNC_COUPDAYBS                                  "SC_HID_AAI_FUNC_COUPDAYBS"
#define HID_AAI_FUNC_COUPPCD                                    "SC_HID_AAI_FUNC_COUPPCD"
#define HID_AAI_FUNC_COUPNUM                                    "SC_HID_AAI_FUNC_COUPNUM"
#define HID_AAI_FUNC_FVSCHEDULE                                 "SC_HID_AAI_FUNC_FVSCHEDULE"
#define HID_AAI_FUNC_ISEVEN                                     "SC_HID_AAI_FUNC_ISEVEN"
#define HID_AAI_FUNC_ISODD                                      "SC_HID_AAI_FUNC_ISODD"
#define HID_AAI_FUNC_GCD                                        "SC_HID_AAI_FUNC_GCD"
#define HID_AAI_FUNC_LCM                                        "SC_HID_AAI_FUNC_LCM"
#define HID_AAI_FUNC_MULTINOMIAL                                "SC_HID_AAI_FUNC_MULTINOMIAL"
#define HID_AAI_FUNC_SERIESSUM                                  "SC_HID_AAI_FUNC_SERIESSUM"
#define HID_AAI_FUNC_QUOTIENT                                   "SC_HID_AAI_FUNC_QUOTIENT"
#define HID_AAI_FUNC_MROUND                                     "SC_HID_AAI_FUNC_MROUND"
#define HID_AAI_FUNC_SQRTPI                                     "SC_HID_AAI_FUNC_SQRTPI"
#define HID_AAI_FUNC_RANDBETWEEN                                "SC_HID_AAI_FUNC_RANDBETWEEN"
#define HID_AAI_FUNC_BESSELI                                    "SC_HID_AAI_FUNC_BESSELI"
#define HID_AAI_FUNC_BESSELJ                                    "SC_HID_AAI_FUNC_BESSELJ"
#define HID_AAI_FUNC_BESSELK                                    "SC_HID_AAI_FUNC_BESSELK"
#define HID_AAI_FUNC_BESSELY                                    "SC_HID_AAI_FUNC_BESSELY"
#define HID_AAI_FUNC_BIN2DEC                                    "SC_HID_AAI_FUNC_BIN2DEC"
#define HID_AAI_FUNC_BIN2HEX                                    "SC_HID_AAI_FUNC_BIN2HEX"
#define HID_AAI_FUNC_BIN2OCT                                    "SC_HID_AAI_FUNC_BIN2OCT"
#define HID_AAI_FUNC_DELTA                                      "SC_HID_AAI_FUNC_DELTA"
#define HID_AAI_FUNC_DEC2BIN                                    "SC_HID_AAI_FUNC_DEC2BIN"
#define HID_AAI_FUNC_DEC2HEX                                    "SC_HID_AAI_FUNC_DEC2HEX"
#define HID_AAI_FUNC_DEC2OCT                                    "SC_HID_AAI_FUNC_DEC2OCT"
#define HID_AAI_FUNC_ERF                                        "SC_HID_AAI_FUNC_ERF"
#define HID_AAI_FUNC_ERFC                                       "SC_HID_AAI_FUNC_ERFC"
#define HID_AAI_FUNC_GESTEP                                     "SC_HID_AAI_FUNC_GESTEP"
#define HID_AAI_FUNC_HEX2BIN                                    "SC_HID_AAI_FUNC_HEX2BIN"
#define HID_AAI_FUNC_HEX2DEC                                    "SC_HID_AAI_FUNC_HEX2DEC"
#define HID_AAI_FUNC_HEX2OCT                                    "SC_HID_AAI_FUNC_HEX2OCT"
#define HID_AAI_FUNC_IMABS                                      "SC_HID_AAI_FUNC_IMABS"
#define HID_AAI_FUNC_IMAGINARY                                  "SC_HID_AAI_FUNC_IMAGINARY"
#define HID_AAI_FUNC_IMPOWER                                    "SC_HID_AAI_FUNC_IMPOWER"
#define HID_AAI_FUNC_IMARGUMENT                                 "SC_HID_AAI_FUNC_IMARGUMENT"
#define HID_AAI_FUNC_IMCOS                                      "SC_HID_AAI_FUNC_IMCOS"
#define HID_AAI_FUNC_IMDIV                                      "SC_HID_AAI_FUNC_IMDIV"
#define HID_AAI_FUNC_IMEXP                                      "SC_HID_AAI_FUNC_IMEXP"
#define HID_AAI_FUNC_IMCONJUGATE                                "SC_HID_AAI_FUNC_IMCONJUGATE"
#define HID_AAI_FUNC_IMLN                                       "SC_HID_AAI_FUNC_IMLN"
#define HID_AAI_FUNC_IMLOG10                                    "SC_HID_AAI_FUNC_IMLOG10"
#define HID_AAI_FUNC_IMLOG2                                     "SC_HID_AAI_FUNC_IMLOG2"
#define HID_AAI_FUNC_IMPRODUCT                                  "SC_HID_AAI_FUNC_IMPRODUCT"
#define HID_AAI_FUNC_IMREAL                                     "SC_HID_AAI_FUNC_IMREAL"
#define HID_AAI_FUNC_IMSIN                                      "SC_HID_AAI_FUNC_IMSIN"
#define HID_AAI_FUNC_IMSUB                                      "SC_HID_AAI_FUNC_IMSUB"
#define HID_AAI_FUNC_IMSUM                                      "SC_HID_AAI_FUNC_IMSUM"
#define HID_AAI_FUNC_IMSQRT                                     "SC_HID_AAI_FUNC_IMSQRT"
#define HID_AAI_FUNC_COMPLEX                                    "SC_HID_AAI_FUNC_COMPLEX"
#define HID_AAI_FUNC_OCT2BIN                                    "SC_HID_AAI_FUNC_OCT2BIN"
#define HID_AAI_FUNC_OCT2DEZ                                    "SC_HID_AAI_FUNC_OCT2DEZ"
#define HID_AAI_FUNC_OCT2HEX                                    "SC_HID_AAI_FUNC_OCT2HEX"
#define HID_AAI_FUNC_CONVERT                                    "SC_HID_AAI_FUNC_CONVERT"
#define HID_AAI_FUNC_FACTDOUBLE                                 "SC_HID_AAI_FUNC_FACTDOUBLE"

// DateFunc Addin Functions (max.20) -----------------------------------------
#define HID_DAI_FUNC_DAYSINMONTH                                "SC_HID_DAI_FUNC_DAYSINMONTH"
#define HID_DAI_FUNC_DAYSINYEAR                                 "SC_HID_DAI_FUNC_DAYSINYEAR"
#define HID_DAI_FUNC_WEEKSINYEAR                                "SC_HID_DAI_FUNC_WEEKSINYEAR"
#define HID_DAI_FUNC_DIFFMONTHS                                 "SC_HID_DAI_FUNC_DIFFMONTHS"
#define HID_DAI_FUNC_DIFFWEEKS                                  "SC_HID_DAI_FUNC_DIFFWEEKS"
#define HID_DAI_FUNC_DIFFYEARS                                  "SC_HID_DAI_FUNC_DIFFYEARS"
#define HID_DAI_FUNC_ROT13                                      "SC_HID_DAI_FUNC_ROT13"

#define HID_SCPAGE_OPREDLINBE_FT_CONTENT                        "SC_HID_SCPAGE_OPREDLINBE_FT_CONTENT"
#define HID_MN_FORMAT_STYLE                                     "SC_HID_MN_FORMAT_STYLE"
#define HID_MN_FORMAT_ALGN                                      "SC_HID_MN_FORMAT_ALGN"
#define HID_MN_FORMAT_LINESPACE                                 "SC_HID_MN_FORMAT_LINESPACE"


// Ende Hilfe IDs ------------------------------------------------------------

#define HID_SC_FUNC_DUMMY                                       "SC_HID_SC_FUNC_DUMMY"

#define HID_FUNC_DBANZAHL                                       "SC_HID_FUNC_DBANZAHL"
#define HID_FUNC_DBANZAHL2                                      "SC_HID_FUNC_DBANZAHL2"
#define HID_FUNC_DBMITTELWERT                                   "SC_HID_FUNC_DBMITTELWERT"
#define HID_FUNC_DBAUSZUG                                       "SC_HID_FUNC_DBAUSZUG"
#define HID_FUNC_DBMAX                                          "SC_HID_FUNC_DBMAX"
#define HID_FUNC_DBMIN                                          "SC_HID_FUNC_DBMIN"
#define HID_FUNC_DBPRODUKT                                      "SC_HID_FUNC_DBPRODUKT"
#define HID_FUNC_DBSTDABW                                       "SC_HID_FUNC_DBSTDABW"
#define HID_FUNC_DBSTDABWN                                      "SC_HID_FUNC_DBSTDABWN"
#define HID_FUNC_DBSUMME                                        "SC_HID_FUNC_DBSUMME"
#define HID_FUNC_DBVARIANZ                                      "SC_HID_FUNC_DBVARIANZ"
#define HID_FUNC_DBVARIANZEN                                    "SC_HID_FUNC_DBVARIANZEN"

#define HID_FUNC_DATUM                                          "SC_HID_FUNC_DATUM"
#define HID_FUNC_DATWERT                                        "SC_HID_FUNC_DATWERT"
#define HID_FUNC_TAG                                            "SC_HID_FUNC_TAG"
#define HID_FUNC_TAGE360                                        "SC_HID_FUNC_TAGE360"
#define HID_FUNC_STUNDE                                         "SC_HID_FUNC_STUNDE"
#define HID_FUNC_MINUTE                                         "SC_HID_FUNC_MINUTE"
#define HID_FUNC_MONAT                                          "SC_HID_FUNC_MONAT"
#define HID_FUNC_JETZT                                          "SC_HID_FUNC_JETZT"
#define HID_FUNC_SEKUNDE                                        "SC_HID_FUNC_SEKUNDE"
#define HID_FUNC_ZEIT                                           "SC_HID_FUNC_ZEIT"
#define HID_FUNC_ZEITWERT                                       "SC_HID_FUNC_ZEITWERT"
#define HID_FUNC_HEUTE                                          "SC_HID_FUNC_HEUTE"
#define HID_FUNC_WOCHENTAG                                      "SC_HID_FUNC_WOCHENTAG"
#define HID_FUNC_JAHR                                           "SC_HID_FUNC_JAHR"
#define HID_FUNC_TAGE                                           "SC_HID_FUNC_TAGE"
#define HID_FUNC_KALENDERWOCHE                                  "SC_HID_FUNC_KALENDERWOCHE"
#define HID_FUNC_OSTERSONNTAG                                   "SC_HID_FUNC_OSTERSONNTAG"

#define HID_FUNC_BW                                             "SC_HID_FUNC_BW"
#define HID_FUNC_ZW                                             "SC_HID_FUNC_ZW"
#define HID_FUNC_ZZR                                            "SC_HID_FUNC_ZZR"
#define HID_FUNC_RMZ                                            "SC_HID_FUNC_RMZ"
#define HID_FUNC_ZINS                                           "SC_HID_FUNC_ZINS"
#define HID_FUNC_ZINSZ                                          "SC_HID_FUNC_ZINSZ"
#define HID_FUNC_KAPZ                                           "SC_HID_FUNC_KAPZ"
#define HID_FUNC_KUMKAPITAL                                     "SC_HID_FUNC_KUMKAPITAL"
#define HID_FUNC_KUMZINSZ                                       "SC_HID_FUNC_KUMZINSZ"
#define HID_FUNC_DIA                                            "SC_HID_FUNC_DIA"
#define HID_FUNC_LIA                                            "SC_HID_FUNC_LIA"
#define HID_FUNC_GDA                                            "SC_HID_FUNC_GDA"
#define HID_FUNC_GDA2                                           "SC_HID_FUNC_GDA2"
#define HID_FUNC_VDB                                            "SC_HID_FUNC_VDB"
#define HID_FUNC_EFFEKTIV                                       "SC_HID_FUNC_EFFEKTIV"
#define HID_FUNC_NOMINAL                                        "SC_HID_FUNC_NOMINAL"
#define HID_FUNC_NBW                                            "SC_HID_FUNC_NBW"
#define HID_FUNC_IKV                                            "SC_HID_FUNC_IKV"
#define HID_FUNC_LAUFZEIT                                       "SC_HID_FUNC_LAUFZEIT"
#define HID_FUNC_ZGZ                                            "SC_HID_FUNC_ZGZ"
#define HID_FUNC_QIKV                                           "SC_HID_FUNC_QIKV"
#define HID_FUNC_ISPMT                                          "SC_HID_FUNC_ISPMT"

#define HID_FUNC_ISTBEZUG                                       "SC_HID_FUNC_ISTBEZUG"
#define HID_FUNC_ISTFEHL                                        "SC_HID_FUNC_ISTFEHL"
#define HID_FUNC_ISTFEHLER                                      "SC_HID_FUNC_ISTFEHLER"
#define HID_FUNC_ISTLEER                                        "SC_HID_FUNC_ISTLEER"
#define HID_FUNC_ISTLOG                                         "SC_HID_FUNC_ISTLOG"
#define HID_FUNC_ISTNV                                          "SC_HID_FUNC_ISTNV"
#define HID_FUNC_ISTKTEXT                                       "SC_HID_FUNC_ISTKTEXT"
#define HID_FUNC_ISTTEXT                                        "SC_HID_FUNC_ISTTEXT"
#define HID_FUNC_ISTZAHL                                        "SC_HID_FUNC_ISTZAHL"
#define HID_FUNC_ISTFORMEL                                      "SC_HID_FUNC_ISTFORMEL"
#define HID_FUNC_N                                              "SC_HID_FUNC_N"
#define HID_FUNC_NV                                             "SC_HID_FUNC_NV"
#define HID_FUNC_TYP                                            "SC_HID_FUNC_TYP"
#define HID_FUNC_AKTUELL                                        "SC_HID_FUNC_AKTUELL"
#define HID_FUNC_FORMEL                                         "SC_HID_FUNC_FORMEL"
#define HID_FUNC_ZELLE                                          "SC_HID_FUNC_ZELLE"
#define HID_FUNC_INFO                                           "SC_HID_FUNC_INFO"


#define HID_FUNC_FALSCH                                         "SC_HID_FUNC_FALSCH"
#define HID_FUNC_NICHT                                          "SC_HID_FUNC_NICHT"
#define HID_FUNC_WAHR                                           "SC_HID_FUNC_WAHR"
#define HID_FUNC_WENN                                           "SC_HID_FUNC_WENN"
#define HID_FUNC_ODER                                           "SC_HID_FUNC_ODER"
#define HID_FUNC_UND                                            "SC_HID_FUNC_UND"

#define HID_FUNC_ABS                                            "SC_HID_FUNC_ABS"
#define HID_FUNC_POTENZ                                         "SC_HID_FUNC_POTENZ"
#define HID_FUNC_ANZAHLLEEREZELLEN                              "SC_HID_FUNC_ANZAHLLEEREZELLEN"
#define HID_FUNC_PI                                             "SC_HID_FUNC_PI"
#define HID_FUNC_SUMME                                          "SC_HID_FUNC_SUMME"
#define HID_FUNC_QUADRATESUMME                                  "SC_HID_FUNC_QUADRATESUMME"
#define HID_FUNC_PRODUKT                                        "SC_HID_FUNC_PRODUKT"
#define HID_FUNC_SUMMEWENN                                      "SC_HID_FUNC_SUMMEWENN"
#define HID_FUNC_ZAEHLENWENN                                    "SC_HID_FUNC_ZAEHLENWENN"
#define HID_FUNC_WURZEL                                         "SC_HID_FUNC_WURZEL"
#define HID_FUNC_ZUFALLSZAHL                                    "SC_HID_FUNC_ZUFALLSZAHL"
#define HID_FUNC_ISTGERADE                                      "SC_HID_FUNC_ISTGERADE"
#define HID_FUNC_ISTUNGERADE                                    "SC_HID_FUNC_ISTUNGERADE"
#define HID_FUNC_KOMBINATIONEN                                  "SC_HID_FUNC_KOMBINATIONEN"
#define HID_FUNC_KOMBINATIONEN2                                 "SC_HID_FUNC_KOMBINATIONEN2"
#define HID_FUNC_ARCCOS                                         "SC_HID_FUNC_ARCCOS"
#define HID_FUNC_ARCSIN                                         "SC_HID_FUNC_ARCSIN"
#define HID_FUNC_ARCOSHYP                                       "SC_HID_FUNC_ARCOSHYP"
#define HID_FUNC_ARSINHYP                                       "SC_HID_FUNC_ARSINHYP"
#define HID_FUNC_ARCCOT                                         "SC_HID_FUNC_ARCCOT"
#define HID_FUNC_ARCTAN                                         "SC_HID_FUNC_ARCTAN"
#define HID_FUNC_ARCOTHYP                                       "SC_HID_FUNC_ARCOTHYP"
#define HID_FUNC_ARTANHYP                                       "SC_HID_FUNC_ARTANHYP"
#define HID_FUNC_COS                                            "SC_HID_FUNC_COS"
#define HID_FUNC_SIN                                            "SC_HID_FUNC_SIN"
#define HID_FUNC_COT                                            "SC_HID_FUNC_COT"
#define HID_FUNC_TAN                                            "SC_HID_FUNC_TAN"
#define HID_FUNC_COSHYP                                         "SC_HID_FUNC_COSHYP"
#define HID_FUNC_SINHYP                                         "SC_HID_FUNC_SINHYP"
#define HID_FUNC_COTHYP                                         "SC_HID_FUNC_COTHYP"
#define HID_FUNC_TANHYP                                         "SC_HID_FUNC_TANHYP"
#define HID_FUNC_ARCTAN2                                        "SC_HID_FUNC_ARCTAN2"
#define HID_FUNC_COSECANT                                       "SC_HID_FUNC_COSECANT"
#define HID_FUNC_SECANT                                         "SC_HID_FUNC_SECANT"
#define HID_FUNC_SECANTHYP                                      "SC_HID_FUNC_SECANTHYP"
#define HID_FUNC_COSECANTHYP                                    "SC_HID_FUNC_COSECANTHYP"
#define HID_FUNC_DEG                                            "SC_HID_FUNC_DEG"
#define HID_FUNC_RAD                                            "SC_HID_FUNC_RAD"
#define HID_FUNC_EXP                                            "SC_HID_FUNC_EXP"
#define HID_FUNC_LOG                                            "SC_HID_FUNC_LOG"
#define HID_FUNC_LN                                             "SC_HID_FUNC_LN"
#define HID_FUNC_LOG10                                          "SC_HID_FUNC_LOG10"
#define HID_FUNC_FAKULTAET                                      "SC_HID_FUNC_FAKULTAET"
#define HID_FUNC_REST                                           "SC_HID_FUNC_REST"
#define HID_FUNC_VORZEICHEN                                     "SC_HID_FUNC_VORZEICHEN"
#define HID_FUNC_TEILERGEBNIS                                   "SC_HID_FUNC_TEILERGEBNIS"
#define HID_FUNC_GANZZAHL                                       "SC_HID_FUNC_GANZZAHL"
#define HID_FUNC_KUERZEN                                        "SC_HID_FUNC_KUERZEN"
#define HID_FUNC_RUNDEN                                         "SC_HID_FUNC_RUNDEN"
#define HID_FUNC_AUFRUNDEN                                      "SC_HID_FUNC_AUFRUNDEN"
#define HID_FUNC_ABRUNDEN                                       "SC_HID_FUNC_ABRUNDEN"
#define HID_FUNC_GERADE                                         "SC_HID_FUNC_GERADE"
#define HID_FUNC_UNGERADE                                       "SC_HID_FUNC_UNGERADE"
#define HID_FUNC_OBERGRENZE                                     "SC_HID_FUNC_OBERGRENZE"
#define HID_FUNC_UNTERGRENZE                                    "SC_HID_FUNC_UNTERGRENZE"
#define HID_FUNC_GGT                                            "SC_HID_FUNC_GGT"
#define HID_FUNC_KGV                                            "SC_HID_FUNC_KGV"
#define HID_FUNC_UMRECHNEN                                      "SC_HID_FUNC_UMRECHNEN"
#define HID_FUNC_EUROCONVERT                                    "SC_HID_FUNC_EUROCONVERT"

#define HID_FUNC_MTRANS                                         "SC_HID_FUNC_MTRANS"
#define HID_FUNC_MMULT                                          "SC_HID_FUNC_MMULT"
#define HID_FUNC_MDET                                           "SC_HID_FUNC_MDET"
#define HID_FUNC_MINV                                           "SC_HID_FUNC_MINV"
#define HID_FUNC_EINHEITSMATRIX                                 "SC_HID_FUNC_EINHEITSMATRIX"
#define HID_FUNC_SUMMENPRODUKT                                  "SC_HID_FUNC_SUMMENPRODUKT"
#define HID_FUNC_SUMMEX2MY2                                     "SC_HID_FUNC_SUMMEX2MY2"
#define HID_FUNC_SUMMEX2PY2                                     "SC_HID_FUNC_SUMMEX2PY2"
#define HID_FUNC_SUMMEXMY2                                      "SC_HID_FUNC_SUMMEXMY2"
#define HID_FUNC_HAEUFIGKEIT                                    "SC_HID_FUNC_HAEUFIGKEIT"
#define HID_FUNC_RGP                                            "SC_HID_FUNC_RGP"
#define HID_FUNC_RKP                                            "SC_HID_FUNC_RKP"
#define HID_FUNC_TREND                                          "SC_HID_FUNC_TREND"
#define HID_FUNC_VARIATION                                      "SC_HID_FUNC_VARIATION"

#define HID_FUNC_ANZAHL                                         "SC_HID_FUNC_ANZAHL"
#define HID_FUNC_ANZAHL2                                        "SC_HID_FUNC_ANZAHL2"
#define HID_FUNC_MAX                                            "SC_HID_FUNC_MAX"
#define HID_FUNC_MIN                                            "SC_HID_FUNC_MIN"
#define HID_FUNC_VARIANZ                                        "SC_HID_FUNC_VARIANZ"
#define HID_FUNC_VARIANZEN                                      "SC_HID_FUNC_VARIANZEN"
#define HID_FUNC_STABW                                          "SC_HID_FUNC_STABW"
#define HID_FUNC_STABWN                                         "SC_HID_FUNC_STABWN"
#define HID_FUNC_MITTELWERT                                     "SC_HID_FUNC_MITTELWERT"
#define HID_FUNC_SUMQUADABW                                     "SC_HID_FUNC_SUMQUADABW"
#define HID_FUNC_MITTELABW                                      "SC_HID_FUNC_MITTELABW"
#define HID_FUNC_SCHIEFE                                        "SC_HID_FUNC_SCHIEFE"
#define HID_FUNC_KURT                                           "SC_HID_FUNC_KURT"
#define HID_FUNC_GEOMITTEL                                      "SC_HID_FUNC_GEOMITTEL"
#define HID_FUNC_HARMITTEL                                      "SC_HID_FUNC_HARMITTEL"
#define HID_FUNC_MODALWERT                                      "SC_HID_FUNC_MODALWERT"
#define HID_FUNC_MEDIAN                                         "SC_HID_FUNC_MEDIAN"
#define HID_FUNC_QUANTIL                                        "SC_HID_FUNC_QUANTIL"
#define HID_FUNC_QUARTILE                                       "SC_HID_FUNC_QUARTILE"
#define HID_FUNC_KGROESSTE                                      "SC_HID_FUNC_KGROESSTE"
#define HID_FUNC_KKLEINSTE                                      "SC_HID_FUNC_KKLEINSTE"
#define HID_FUNC_QUANTILSRANG                                   "SC_HID_FUNC_QUANTILSRANG"
#define HID_FUNC_RANG                                           "SC_HID_FUNC_RANG"
#define HID_FUNC_GESTUTZTMITTEL                                 "SC_HID_FUNC_GESTUTZTMITTEL"
#define HID_FUNC_WAHRSCHBEREICH                                 "SC_HID_FUNC_WAHRSCHBEREICH"
#define HID_FUNC_B                                              "SC_HID_FUNC_B"
#define HID_FUNC_PHI                                            "SC_HID_FUNC_PHI"
#define HID_FUNC_GAUSS                                          "SC_HID_FUNC_GAUSS"
#define HID_FUNC_FISHER                                         "SC_HID_FUNC_FISHER"
#define HID_FUNC_FISHERINV                                      "SC_HID_FUNC_FISHERINV"
#define HID_FUNC_BINOMVERT                                      "SC_HID_FUNC_BINOMVERT"
#define HID_FUNC_NEGBINOMVERT                                   "SC_HID_FUNC_NEGBINOMVERT"
#define HID_FUNC_KRITBINOM                                      "SC_HID_FUNC_KRITBINOM"
#define HID_FUNC_POISSON                                        "SC_HID_FUNC_POISSON"
#define HID_FUNC_NORMVERT                                       "SC_HID_FUNC_NORMVERT"
#define HID_FUNC_NORMINV                                        "SC_HID_FUNC_NORMINV"
#define HID_FUNC_STANDNORMVERT                                  "SC_HID_FUNC_STANDNORMVERT"
#define HID_FUNC_STANDNORMINV                                   "SC_HID_FUNC_STANDNORMINV"
#define HID_FUNC_LOGNORMVERT                                    "SC_HID_FUNC_LOGNORMVERT"
#define HID_FUNC_LOGINV                                         "SC_HID_FUNC_LOGINV"
#define HID_FUNC_EXPONVERT                                      "SC_HID_FUNC_EXPONVERT"
#define HID_FUNC_GAMMAVERT                                      "SC_HID_FUNC_GAMMAVERT"
#define HID_FUNC_GAMMAINV                                       "SC_HID_FUNC_GAMMAINV"
#define HID_FUNC_GAMMALN                                        "SC_HID_FUNC_GAMMALN"
#define HID_FUNC_BETAVERT                                       "SC_HID_FUNC_BETAVERT"
#define HID_FUNC_BETAINV                                        "SC_HID_FUNC_BETAINV"
#define HID_FUNC_WEIBULL                                        "SC_HID_FUNC_WEIBULL"
#define HID_FUNC_HYPGEOMVERT                                    "SC_HID_FUNC_HYPGEOMVERT"
#define HID_FUNC_TVERT                                          "SC_HID_FUNC_TVERT"
#define HID_FUNC_TINV                                           "SC_HID_FUNC_TINV"
#define HID_FUNC_FVERT                                          "SC_HID_FUNC_FVERT"
#define HID_FUNC_FINV                                           "SC_HID_FUNC_FINV"
#define HID_FUNC_CHIVERT                                        "SC_HID_FUNC_CHIVERT"
#define HID_FUNC_CHIINV                                         "SC_HID_FUNC_CHIINV"
#define HID_FUNC_STANDARDISIERUNG                               "SC_HID_FUNC_STANDARDISIERUNG"
#define HID_FUNC_VARIATIONEN                                    "SC_HID_FUNC_VARIATIONEN"
#define HID_FUNC_VARIATIONEN2                                   "SC_HID_FUNC_VARIATIONEN2"
#define HID_FUNC_KONFIDENZ                                      "SC_HID_FUNC_KONFIDENZ"
#define HID_FUNC_GTEST                                          "SC_HID_FUNC_GTEST"
#define HID_FUNC_CHITEST                                        "SC_HID_FUNC_CHITEST"
#define HID_FUNC_FTEST                                          "SC_HID_FUNC_FTEST"
#define HID_FUNC_TTEST                                          "SC_HID_FUNC_TTEST"
#define HID_FUNC_BESTIMMTHEITSMASS                              "SC_HID_FUNC_BESTIMMTHEITSMASS"
#define HID_FUNC_ACHSENABSCHNITT                                "SC_HID_FUNC_ACHSENABSCHNITT"
#define HID_FUNC_STEIGUNG                                       "SC_HID_FUNC_STEIGUNG"
#define HID_FUNC_STFEHLERYX                                     "SC_HID_FUNC_STFEHLERYX"
#define HID_FUNC_PEARSON                                        "SC_HID_FUNC_PEARSON"
#define HID_FUNC_KORREL                                         "SC_HID_FUNC_KORREL"
#define HID_FUNC_KOVAR                                          "SC_HID_FUNC_KOVAR"
#define HID_FUNC_SCHAETZER                                      "SC_HID_FUNC_SCHAETZER"
#define HID_FUNC_MINA                                           "SC_HID_FUNC_MINA"
#define HID_FUNC_MAXA                                           "SC_HID_FUNC_MAXA"
#define HID_FUNC_MITTELWERTA                                    "SC_HID_FUNC_MITTELWERTA"
#define HID_FUNC_STABWA                                         "SC_HID_FUNC_STABWA"
#define HID_FUNC_STABWNA                                        "SC_HID_FUNC_STABWNA"
#define HID_FUNC_VARIANZA                                       "SC_HID_FUNC_VARIANZA"
#define HID_FUNC_VARIANZENA                                     "SC_HID_FUNC_VARIANZENA"
#define HID_FUNC_CHISQDIST                                      "SC_HID_FUNC_CHISQDIST"
#define HID_FUNC_CHISQINV                                       "SC_HID_FUNC_CHISQINV"
#define HID_FUNC_GAMMA                                          "SC_HID_FUNC_GAMMA"

#define HID_FUNC_ADRESSE                                        "SC_HID_FUNC_ADRESSE"
#define HID_FUNC_BEREICHE                                       "SC_HID_FUNC_BEREICHE"
#define HID_FUNC_WAHL                                           "SC_HID_FUNC_WAHL"
#define HID_FUNC_SPALTE                                         "SC_HID_FUNC_SPALTE"
#define HID_FUNC_ZEILE                                          "SC_HID_FUNC_ZEILE"
#define HID_FUNC_SPALTEN                                        "SC_HID_FUNC_SPALTEN"
#define HID_FUNC_ZEILEN                                         "SC_HID_FUNC_ZEILEN"
#define HID_FUNC_WVERWEIS                                       "SC_HID_FUNC_WVERWEIS"
#define HID_FUNC_SVERWEIS                                       "SC_HID_FUNC_SVERWEIS"
#define HID_FUNC_INDEX                                          "SC_HID_FUNC_INDEX"
#define HID_FUNC_INDIREKT                                       "SC_HID_FUNC_INDIREKT"
#define HID_FUNC_VERWEIS                                        "SC_HID_FUNC_VERWEIS"
#define HID_FUNC_VERGLEICH                                      "SC_HID_FUNC_VERGLEICH"
#define HID_FUNC_VERSCHIEBUNG                                   "SC_HID_FUNC_VERSCHIEBUNG"
#define HID_FUNC_FEHLERTYP                                      "SC_HID_FUNC_FEHLERTYP"
#define HID_FUNC_VORLAGE                                        "SC_HID_FUNC_VORLAGE"
#define HID_FUNC_DDE                                            "SC_HID_FUNC_DDE"
#define HID_FUNC_TABELLE                                        "SC_HID_FUNC_TABELLE"
#define HID_FUNC_TABELLEN                                       "SC_HID_FUNC_TABELLEN"
#define HID_FUNC_HYPERLINK                                      "SC_HID_FUNC_HYPERLINK"
#define HID_FUNC_GETPIVOTDATA                                   "SC_HID_FUNC_GETPIVOTDATA"

#define HID_FUNC_CODE                                           "SC_HID_FUNC_CODE"
#define HID_FUNC_DM                                             "SC_HID_FUNC_DM"
#define HID_FUNC_ZEICHEN                                        "SC_HID_FUNC_ZEICHEN"
#define HID_FUNC_SAEUBERN                                       "SC_HID_FUNC_SAEUBERN"
#define HID_FUNC_VERKETTEN                                      "SC_HID_FUNC_VERKETTEN"
#define HID_FUNC_IDENTISCH                                      "SC_HID_FUNC_IDENTISCH"
#define HID_FUNC_FINDEN                                         "SC_HID_FUNC_FINDEN"
#define HID_FUNC_SUCHEN                                         "SC_HID_FUNC_SUCHEN"
#define HID_FUNC_GLAETTEN                                       "SC_HID_FUNC_GLAETTEN"
#define HID_FUNC_GROSS2                                         "SC_HID_FUNC_GROSS2"
#define HID_FUNC_GROSS                                          "SC_HID_FUNC_GROSS"
#define HID_FUNC_KLEIN                                          "SC_HID_FUNC_KLEIN"
#define HID_FUNC_WERT                                           "SC_HID_FUNC_WERT"
#define HID_FUNC_TEXT                                           "SC_HID_FUNC_TEXT"
#define HID_FUNC_T                                              "SC_HID_FUNC_T"
#define HID_FUNC_ERSETZEN                                       "SC_HID_FUNC_ERSETZEN"
#define HID_FUNC_FEST                                           "SC_HID_FUNC_FEST"
#define HID_FUNC_LAENGE                                         "SC_HID_FUNC_LAENGE"
#define HID_FUNC_LINKS                                          "SC_HID_FUNC_LINKS"
#define HID_FUNC_RECHTS                                         "SC_HID_FUNC_RECHTS"
#define HID_FUNC_TEIL                                           "SC_HID_FUNC_TEIL"
#define HID_FUNC_WIEDERHOLEN                                    "SC_HID_FUNC_WIEDERHOLEN"
#define HID_FUNC_WECHSELN                                       "SC_HID_FUNC_WECHSELN"
#define HID_FUNC_BASIS                                          "SC_HID_FUNC_BASIS"
#define HID_FUNC_DEZIMAL                                        "SC_HID_FUNC_DEZIMAL"
#define HID_FUNC_ROEMISCH                                       "SC_HID_FUNC_ROEMISCH"
#define HID_FUNC_ARABISCH                                       "SC_HID_FUNC_ARABISCH"
#define HID_FUNC_BAHTTEXT                                       "SC_HID_FUNC_BAHTTEXT"
#define HID_FUNC_JIS                                            "SC_HID_FUNC_JIS"
#define HID_FUNC_ASC                                            "SC_HID_FUNC_ASC"
#define HID_FUNC_UNICODE                                        "SC_HID_FUNC_UNICODE"
#define HID_FUNC_UNICHAR                                        "SC_HID_FUNC_UNICHAR"
#define HID_FUNC_NUMBERVALUE                                    "SC_HID_FUNC_NUMBERVALUE"
#define HID_FUNC_BITAND                                         "SC_HID_FUNC_BITAND"
#define HID_FUNC_BITOR                                          "SC_HID_FUNC_BITOR"
#define HID_FUNC_BITXOR                                         "SC_HID_FUNC_BITXOR"
#define HID_FUNC_BITLSHIFT                                      "SC_HID_FUNC_BITLSHIFT"
#define HID_FUNC_BITRSHIFT                                      "SC_HID_FUNC_BITRSHIFT"

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
