/*
 * This file is part of libbluray
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 */

package java.io;

public final class FileDescriptor {

    /* for files used by JVM */
    private int  fd;
    private long handle;

    /* for files in BD VFS */
    private long fp;

    /* for files inside .jar */
    protected InputStream slave;

    private int useCount;

    public FileDescriptor() {
	fd = -1;
        handle = -1;
        fp = 0;
        slave = null;
        useCount = 0;
    }

    private FileDescriptor(int fd) {
        this();
	this.fd = fd;
    }

    public static final FileDescriptor in  = new FileDescriptor(0);
    public static final FileDescriptor out = new FileDescriptor(1);
    public static final FileDescriptor err = new FileDescriptor(2);

    public boolean valid() {
	return (fd != -1) || (handle != -1) || (fp != 0) || (slave != null);
    }

    public native void sync() throws SyncFailedException;

    private static native void initIDs();

    static {
	initIDs();
    }

    int incrementAndGetUseCount() {
        synchronized (this) {
            useCount = useCount + 1;
            return useCount;
        }
    }

    int decrementAndGetUseCount() {
        synchronized (this) {
            useCount = useCount - 1;
            return useCount;
        }
    }

    /* Java 8 */
    void attach(Closeable c) {
    }
}
