/*****************************************************************************
 * parser.cpp : SAP configuration file parser
 ****************************************************************************
 * Copyright (C) 1998-2002 VideoLAN
 * $Id: parser.cpp,v 1.5 2003/06/16 15:30:11 zorglub Exp $
 *
 * Authors: Arnaud Schauly <gitan@via.ecp.fr>
 *          Clment Stenac <zorglub@via.ecp.fr>
 *          Damien Lucas <nitrox@videolan.org>
 *          Philippe Van Hecke <philippe.vanhecke@belnet.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string>
#include <vector>

using namespace std;

#include "sapserver.h"
#include "program.h"
#include "message.h"
#include "parser.h"


Config::Config(string f)
{
    file	=	f;
    ttl		=	DEFAULT_TTL;
    scope	=	DEFAULT_SCOPE;
}

Config::~Config()
{
    //TODO free the Programs table
}

unsigned int Config::GetTTL()
{
    return ttl;
}

void Config::SetTTL(unsigned int t)
{
    ttl=t;
}

bool Config::GetDaemonMode(void)
{
    return daemon;
}

void Config::SetDaemonMode(bool d)
{
    daemon=true;
}

bool Config::GetDotMode(void)
{
    return dot;
}

void Config::SetDotMode(bool d)
{
    dot=true;
}


void Config::SetFile(char* s)
{
    file=s;
}

int Config::GetIPVersion()
{
    return ipversion;
}

char Config::GetScope()
{
    return scope[0];
}

/**********************************************************
 * Gets what is before delim in source. Puts it into dest *
 **********************************************************/
void Config::strgetb(char *source,char *dest,char delim)
{
        unsigned long i = 0;
        while(source[i] != delim && i < strlen(source))
        {
                dest[i]=source[i];
                i++;
        }
        dest[i]=0;
}

/********************************************************** 
 * Gets what is before delim in source. Puts it into dest * 
 **********************************************************/ 
void Config::strgeta(char *source,char *dest,char delim)
{
    unsigned long i=0,j=0;
    dest[0]=0;
    while(source[i] != delim && i < strlen(source))
    {
        i++;
    }
    i++;
    if(i>=strlen(source))
    {
        return;
    }
    while(i < strlen(source))
    {
        if(source[i]!='\n') dest[j]=source[i];
        else dest[j]=0;
        j++;i++;
    }
    dest[j]=0;
}


/********************************************************************
  Reads the configuration file and fills the program list
*********************************************************************/
int Config::Parse()
{
    FILE *fd;
    char line[1024];   //TODO line length should not be limited
    char tline[1024];
    unsigned int something=0;
    Program *pp= new Program();

    fd=fopen(file.c_str(),"r");
    if(!fd)
    {
        fprintf(stderr, "- Unable to open %s\n",file.c_str());
        return(-1);
    }

    while(!feof(fd))
    {
        memset(line,'0',1024);
        fgets(line,1024,fd);

        if(!strlen(line))
        {
            break;
        }

        strgetb(line,line,'#'); /* Handle the comments */

	/* Set SAP TTL  (ttl is a member of config) */
        if(strstr(line,"sap_ttl="))
        {
            strgeta(line,tline,'=');
            ttl=atoi(tline);
        }
	
	/* Set SAP IP Version  (ipversion is a member of config) */
        if(strstr(line,"sap_ipversion="))
        {
            strgeta(line,tline,'=');
            ipversion=atoi(tline);
        }

	/* Set SAP IPv6 Scope  (scope is a member of config) */
        if(strstr(line,"ipv6_scope="))
        {
            strgeta(line,tline,'=');
            scope=strdup(tline);
        }

	/*  Beginning of programs parsing */
        if(strstr(line,"[program]"))
        {
            if(something)
            {
                /* We were in a program with at least one field filled */
		if (!pp->GetPort().length())
		{
		  pp->SetPort(DEFAULT_PORT);
		}
                Programs.push_back(pp);
                pp=new Program();
                something=0;
            }
        }

        if(strstr(line,"name="))
        {
            strgeta(line,tline,'=');
            something=1;
            pp->SetName(tline);
        }

        if(strstr(line,"program_ttl="))
        {
            strgeta(line,tline,'=');
            something=1;
            pp->SetTTL(tline);
        }

        if(strstr(line,"program_ipversion="))
        {
            strgeta(line,tline,'=');
            something=1;
            pp->SetIPVersion(tline);
        }

        if(strstr(line,"user="))
        {
            strgeta(line,tline,'=');
            something=1;
            pp->SetUser(tline);
        }

        if(strstr(line,"machine="))
        {
            strgeta(line,tline,'=');
            something=1;
            pp->SetMachine(tline);
        }

        if(strstr(line,"site="))
        {
            strgeta(line,tline,'=');
            something=1;
            pp->SetSite(tline);
        }

        if(strstr(line,"address="))
        {
            strgeta(line,tline,'=');
            something=1;
            pp->SetAddress(tline);
        }
	if(strstr(line,"port="))
	{
	    strgeta(line,tline,'=');
	    something=1;
	    pp->SetPort(tline); 
	}
    }

    if(something) 
    {
 
     if (!pp->GetPort().length())
     {
          pp->SetPort(DEFAULT_PORT);
     }
     Programs.push_back(pp);
    }
    return(0);
}
