/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v7.appcompat.R;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

public class LinearLayoutICS
extends LinearLayout {
    private static final int SHOW_DIVIDER_NONE = 0;
    private static final int SHOW_DIVIDER_BEGINNING = 1;
    private static final int SHOW_DIVIDER_MIDDLE = 2;
    private static final int SHOW_DIVIDER_END = 4;
    private final Drawable mDivider;
    private final int mDividerWidth;
    private final int mDividerHeight;
    private final int mShowDividers;
    private final int mDividerPadding;

    public LinearLayoutICS(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LinearLayoutICS);
        this.mDivider = a.getDrawable(0);
        if (this.mDivider != null) {
            this.mDividerWidth = this.mDivider.getIntrinsicWidth();
            this.mDividerHeight = this.mDivider.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        this.mShowDividers = a.getInt(1, 0);
        this.mDividerPadding = a.getDimensionPixelSize(2, 0);
        a.recycle();
        this.setWillNotDraw(this.mDivider == null);
    }

    public int getSupportDividerWidth() {
        return this.mDividerWidth;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDivider == null) {
            return;
        }
        if (this.getOrientation() == 1) {
            this.drawSupportDividersVertical(canvas);
        } else {
            this.drawSupportDividersHorizontal(canvas);
        }
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        if (this.mDivider != null) {
            int childIndex = this.indexOfChild(child);
            int count = this.getChildCount();
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)child.getLayoutParams();
            if (this.getOrientation() == 1) {
                if (this.hasSupportDividerBeforeChildAt(childIndex)) {
                    params.topMargin = this.mDividerHeight;
                } else if (childIndex == count - 1 && this.hasSupportDividerBeforeChildAt(count)) {
                    params.bottomMargin = this.mDividerHeight;
                }
            } else if (this.hasSupportDividerBeforeChildAt(childIndex)) {
                params.leftMargin = this.mDividerWidth;
            } else if (childIndex == count - 1 && this.hasSupportDividerBeforeChildAt(count)) {
                params.rightMargin = this.mDividerWidth;
            }
        }
        super.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    void drawSupportDividersVertical(Canvas canvas) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasSupportDividerBeforeChildAt(i)) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            this.drawSupportHorizontalDivider(canvas, child.getTop() - lp.topMargin);
        }
        if (this.hasSupportDividerBeforeChildAt(count)) {
            View child = this.getChildAt(count - 1);
            int bottom = 0;
            bottom = child == null ? this.getHeight() - this.getPaddingBottom() - this.mDividerHeight : child.getBottom();
            this.drawSupportHorizontalDivider(canvas, bottom);
        }
    }

    void drawSupportDividersHorizontal(Canvas canvas) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasSupportDividerBeforeChildAt(i)) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            this.drawSupportVerticalDivider(canvas, child.getLeft() - lp.leftMargin);
        }
        if (this.hasSupportDividerBeforeChildAt(count)) {
            View child = this.getChildAt(count - 1);
            int right = 0;
            right = child == null ? this.getWidth() - this.getPaddingRight() - this.mDividerWidth : child.getRight();
            this.drawSupportVerticalDivider(canvas, right);
        }
    }

    void drawSupportHorizontalDivider(Canvas canvas, int top) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, top, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, top + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    void drawSupportVerticalDivider(Canvas canvas, int left) {
        this.mDivider.setBounds(left, this.getPaddingTop() + this.mDividerPadding, left + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    protected boolean hasSupportDividerBeforeChildAt(int childIndex) {
        if (childIndex == 0) {
            return (this.mShowDividers & 1) != 0;
        }
        if (childIndex == this.getChildCount()) {
            return (this.mShowDividers & 4) != 0;
        }
        if ((this.mShowDividers & 2) != 0) {
            boolean hasVisibleViewBefore = false;
            for (int i = childIndex - 1; i >= 0; --i) {
                if (this.getChildAt(i).getVisibility() == 8) continue;
                hasVisibleViewBefore = true;
                break;
            }
            return hasVisibleViewBefore;
        }
        return false;
    }
}

