/****************************************************************************
** libebml : parse EBML files, see http://embl.sourceforge.net/
**
** <file/class description>
**
** Copyright (C) 2002-2004 Steve Lhomme.  All rights reserved.
**
** This file is part of libebml.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

/*!
	\file
	\version \$Id: EbmlContexts.h,v 1.4 2004/01/10 15:31:02 robux4 Exp $
	\author Steve Lhomme     <robux4 @ users.sf.net>
*/
#ifndef LIBEBML_CONTEXTS_H
#define LIBEBML_CONTEXTS_H

#include "EbmlTypes.h"
#include "EbmlElement.h"

START_LIBEBML_NAMESPACE

extern const EbmlSemanticContext EBML_DLL_API EbmlHead_Context;
extern const EbmlSemanticContext EBML_DLL_API EVersion_Context;
extern const EbmlSemanticContext EBML_DLL_API EReadVersion_Context;
extern const EbmlSemanticContext EBML_DLL_API EMaxIdLength_Context;
extern const EbmlSemanticContext EBML_DLL_API EMaxSizeLength_Context;
extern const EbmlSemanticContext EBML_DLL_API EDocType_Context;
extern const EbmlSemanticContext EBML_DLL_API EDocTypeVersion_Context;
extern const EbmlSemanticContext EBML_DLL_API EDocTypeReadVersion_Context;

// global elements
extern const EbmlSemanticContext EBML_DLL_API EbmlVoid_Context;
extern const EbmlSemanticContext & EBML_DLL_API GetEbmlGlobal_Context();
	
END_LIBEBML_NAMESPACE

#endif // LIBEBML_CONTEXTS_H
