/////////////////////////////////////////////////////////////////////////////
// Name:        _colour.i
// Purpose:     SWIG interface for wxColour
//
// Author:      Robin Dunn
//
// Created:     7-July-1997
// RCS-ID:      $Id: _colour.i,v 1.7 2003/12/18 00:02:35 RD Exp $
// Copyright:   (c) 2003 by Total Control Software
// Licence:     wxWindows license
/////////////////////////////////////////////////////////////////////////////

// Not a %module


//---------------------------------------------------------------------------
%newgroup;


class wxColour : public wxObject {
public:
    wxColour(unsigned char red=0, unsigned char green=0, unsigned char blue=0);
    ~wxColour();

    %name(NamedColour) wxColour( const wxString& colorName);
    %name(ColourRGB) wxColour( unsigned long colRGB );

    unsigned char Red();
    unsigned char Green();
    unsigned char Blue();
    bool Ok();
    void Set(unsigned char red, unsigned char green, unsigned char blue);
    %name(SetRGB) void Set(unsigned long colRGB);

    bool operator==(const wxColour& colour) const;
    bool operator != (const wxColour& colour) const;

    void InitFromName(const wxString& colourName);

    %extend {
        PyObject* Get() {
            PyObject* rv = PyTuple_New(3);
            int red = -1;
            int green = -1;
            int blue = -1;
            if (self->Ok()) {
                red =   self->Red();
                green = self->Green();
                blue =  self->Blue();
            }
            PyTuple_SetItem(rv, 0, PyInt_FromLong(red));
            PyTuple_SetItem(rv, 1, PyInt_FromLong(green));
            PyTuple_SetItem(rv, 2, PyInt_FromLong(blue));
            return rv;
        }
//         bool __eq__(PyObject* obj) {
//             wxColour  tmp;
//             wxColour* ptr = &tmp;
//             if (obj == Py_None)    return False;
//             wxPyBLOCK_THREADS(bool success = wxColour_helper(obj, &ptr); PyErr_Clear());
//             if (! success)         return False;
//             return *self == *ptr;
//         }
//         bool __ne__(PyObject* obj) {
//             wxColour  tmp;
//             wxColour* ptr = &tmp;
//             if (obj == Py_None)    return True;
//             wxPyBLOCK_THREADS(bool success = wxColour_helper(obj, &ptr); PyErr_Clear());
//             if (! success)         return True;
//             return *self != *ptr;
//         }
    }


    %pythoncode {
        asTuple = Get
        def __str__(self):                  return str(self.asTuple())
        def __repr__(self):                 return 'wx.Colour' + str(self.asTuple())
        def __nonzero__(self):              return self.Ok()
        def __getinitargs__(self):          return ()
        def __getstate__(self):             return self.asTuple()
        def __setstate__(self, state):      self.Set(*state)
        }
};

%pythoncode {
    Color = Colour
    NamedColor = NamedColour    
}
//---------------------------------------------------------------------------

