// ThreadRender.cpp: implementation of the ThreadRender class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <process.h>
#include "ThreadRender.h"
#include "wmp9_goom.h"
#include "..\tinyptc.h"
extern "C" {
#include "..\gmtimer.h"
#include "..\..\plugin_info.h"
void  __stdcall goom_init (unsigned int resx, unsigned int, int cinemascope);
void  __stdcall goom_set_resolution (unsigned int resx, unsigned int resy, int cinemascope);
unsigned int *  __stdcall goom_update ( short data[2][512], int forceMode, float fps,
											char *songTitle, char *message);
void   __stdcall  goom_close ();
PluginInfo*  __stdcall  goom_get_plugin ();
}
#include "..\frame_rate_tester.h"

extern "C" {
	int ptc_gl_open(char *, int, int);
	int ptc_gl_set_hwnd(void *);
	int ptc_gl_close();
	int ptc_gl_update(void *);
	void ReSizeGLScene(int,int);
	int ptc_gl_set_parent(HWND, HINSTANCE);
	int ptc_gl_idle_loop();
	int ptc_set_parent(HWND, HINSTANCE);
	int ptc_idle_loop();
}

extern "C" int do_destroy;

extern int goom_width;
extern int goom_height;
extern int win_width;
extern int win_height;
extern bool win_gl;
extern HWND win_wnd;
extern PluginInfo* renderplug;
extern int win_ok;
#define ENCORE_NUL_LOCK (32*60)
static int encore_nul = 0;
static int msg_pos = 0;
extern "C" int msg_rotate_ogl;
extern "C" char * __stdcall readme();
extern "C" float zshift;
#define VERSION "2k4"
static char *msg_tab[] = {
	"What a GOOM! version " VERSION
	"\n\n\n\n\n\n\n\n"
	"an iOS sotfware production.\n"
	"\n\n\n"
	"http://ios.free.fr",
	"", // will be replaced by readme()
	"copyright (c)2000-2004, by jeko"
};
static int encore_frame_ogl[] = { /* Note the times are off by one because msg_pos is incremented */
	32*15,						/* drawglgoom is called */
	32*20,
	32*35
};
static char *err_message = NULL;
static const float fratelim[] = {5.0f,10.0f,15.0f,20.0f,25.0f,30.0f,-1.0f};

#include "Regsettings.h"

extern RegSettings *regset;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

static char *check_message_update(ThreadRender *thr)
{
	int i;
	char *message = NULL;

	/*
	for (i=0;i<512;i++)
		if (data[0][i]>2) {
			if (encore_nul > ENCORE_NUL_LOCK)
				encore_nul = 0;
			break;
		}
		*/

	if (thr->levels_state == 2 && encore_nul > ENCORE_NUL_LOCK) {
		encore_nul = 0;
		i = 0;
	} else {
		i = 512;
	}
	
	if ((i == 512) && (encore_nul == 0))
		encore_nul = ENCORE_NUL_LOCK + 100;

	if (encore_nul == ENCORE_NUL_LOCK) {
		message = msg_tab[msg_pos];
		msg_pos ++;
		msg_pos %= 3;
	}

	msg_rotate_ogl = 0;
	if (encore_nul <= ENCORE_NUL_LOCK) { // wait a while before starting
		if (thr->levels_state != 2) { // only rotate if we're not playing
			if (encore_nul > (ENCORE_NUL_LOCK - encore_frame_ogl[msg_pos])) { // shorten delay to resume rotating
				msg_rotate_ogl = 1;
			}
		}
	}

	if (encore_nul > 0) {
		encore_nul --;
	}

	return message;
}

unsigned int __stdcall ThreadRender::thefunc(void *pv)
{
	ThreadRender *thr = (ThreadRender *)pv;

	int exp_w;
	int exp_h;
	bool exp_gl;
	HWND exp_hwnd;
	GMTimer *t;
	float time1,time2,time3;
	bool updateWait = false;

		exp_gl = regset->surface_gl;
		if (exp_gl) {
			exp_w = 256;
			exp_h = 256;
		} else {
			exp_w = thr->surface_width;
			exp_h = thr->surface_height;
		}
				if (exp_gl) {
					ptc_gl_set_parent(thr->hwnd,thr->hinst);
//					ptc_gl_set_hwnd(thr->hwnd);
					win_ok = ptc_gl_open("Goom",256,256);
					zshift = regset->zsval;
					win_width = 256;
					win_height = 256;
					if (win_ok == 0) {
						err_message = "Failed To Initialize OpenGL :(";
					} else {
						err_message = NULL;
					}
					win_gl=true;
				} else {
					ptc_set_parent(thr->hwnd,thr->hinst);
//					ptc_set_hwnd(m_hwndParent);
					win_ok = ptc_open("Goom",exp_w,exp_h);
					win_width = exp_w;
					win_height = exp_h;
					if (win_ok == 0) {
						err_message = "Failed To Initialize DirectDraw :(";
					} else {
						err_message = NULL;
					}
					win_gl=false;
				}
				if (win_ok != 0) win_wnd = thr->hwnd;

//	thr->Pause();
	t = gmtimer_new();
	time1 = gmtimer_getvalue (t);
	time3 = time1;

	do_destroy=1;
	while (true) {
		while(thr->bPause) {
			int iret;
			if (win_gl) {
				iret=ptc_gl_idle_loop();
			} else {
				iret=ptc_idle_loop();
			}
			if (iret == 0) {
				thr->bQuit=true;
				break;
			}
			if (thr->bQuit) break;
			if (thr->bUpdate && updateWait) {
				updateWait=false;
				thr->bPause=false;
				break;
			}
		}
		if (thr->bQuit) break;
		exp_gl = regset->surface_gl;
		if (exp_gl) {
			exp_w = 256;
			exp_h = 256;
		} else {
			exp_w = thr->surface_width;
			exp_h = thr->surface_height;
		}
		exp_hwnd = thr->hwnd;

	
		if (win_width != exp_w || win_height != exp_h || win_gl != exp_gl || win_wnd != exp_hwnd) {
			if (!exp_gl || !win_gl || win_wnd != exp_hwnd) {
				if (win_gl) {
					if (win_ok != 0) ptc_gl_close();
				} else {
					if (win_ok != 0) ptc_close();
				}
				Sleep(2);
				if (exp_gl) {
					ptc_gl_set_parent(thr->hwnd,thr->hinst);
//					ptc_gl_set_hwnd(thr->hwnd);
					win_ok = ptc_gl_open("Goom",256,256);
					zshift = regset->zsval;
					win_width = 256;
					win_height = 256;
					if (win_ok == 0) {
						err_message = "Failed To Initialize OpenGL :(";
					} else {
						err_message = NULL;
					}
				} else {
					ptc_set_parent(thr->hwnd,thr->hinst);
//					ptc_set_hwnd(m_hwndParent);
					win_ok = ptc_open("Goom",exp_w,exp_h);
					win_width = exp_w;
					win_height = exp_h;
					if (win_ok == 0) {
						err_message = "Failed To Initialize DirectDraw :(";
					} else {
						err_message = NULL;
					}
				}
			}
			win_gl = exp_gl;
			if (win_ok != 0) win_wnd = exp_hwnd;
		}

		if (win_ok == 0) break;

		EnterCriticalSection(&thr->crsec);
		if (goom_width != exp_w || goom_height != exp_h) {
			if (!exp_gl || !win_gl) {
				if (exp_gl) {
					goom_set_resolution(256,256,0);
					goom_width = 256;
					goom_height = 256;
				} else {
					goom_set_resolution(exp_w, exp_h,0);
					goom_width = exp_w;
					goom_height = exp_h;
				}
			} else if (goom_width != 256 || goom_height != 256) {
				goom_set_resolution(256,256,0);
				goom_width = 256;
				goom_height = 256;
			}
		}



		float fps;
		fps = framerate_tester_getvalue();
		if (!regset->showfps) fps = -1.0f;
	
		char *st = thr->songTitle;
		if (!regset->showtitle) st = NULL;

		char *message = check_message_update(thr);

		unsigned int *buf = goom_update(thr->data,0,fps,st,message);
		framerate_tester_newframe();

		if (st != NULL) {
//			delete[] st;
			thr->songUsed=st;
			thr->songTitle=NULL;
		}
		float spf=-1.0f;
		if (regset->fpslim >= 0 && regset->fpslim <= 6) {
			spf=1.0f/fratelim[regset->fpslim];
		} else {
			spf=-1.0f;
		}
		time2 = gmtimer_getvalue (t);
		if (thr->bUpdate) {
			time3=time2;
			thr->bUpdate=false;
		}
		DWORD sleepti=0;
		if (spf < 0.0) {
			time1=time2;
		} else {
			if ((time2 - time1) < spf) {
				sleepti = (DWORD)(1000.0*(spf + time1 - time2));
				time1 = time1 + spf;
			}
			else
				time1 = time2;
		}
		LeaveCriticalSection(&thr->crsec);

		if (thr->bQuit) break;
		if (sleepti > 0) Sleep(sleepti);

		if (win_gl) {
			RECT cr;
			::GetClientRect(win_wnd,&cr);
			if ((cr.right - cr.left) != (thr->oldRect.right - thr->oldRect.left) || 
				(cr.bottom - cr.top) != (thr->oldRect.bottom - thr->oldRect.top)) {
				ReSizeGLScene(cr.right - cr.left,cr.bottom - cr.top);
				::CopyRect(&thr->oldRect,&cr);
			}
			if (ptc_gl_update(buf) == 0) break;
		} else {
			if (ptc_update(buf) == 0) break;
		}
		if ((time2-time3) > 2.0f) {
			updateWait=true;
			thr->bPause=true;
		}
	}
	gmtimer_delete(&t);
	OutputDebugString("Outside Thread Loop\n");
//	do_destroy=0;
#if 1
	if (win_ok != 0) {
		if (win_gl) {
			ptc_gl_close();
		} else {
			ptc_close();
		}
		win_ok=0;
		win_wnd=NULL;
		thr->done=true;// this pretty much poisons this thr
	}
#endif
	thr->bQuit=true;
	return 0;
}

ThreadRender::ThreadRender(HWND hwnd1, HINSTANCE hinst1, int w, int h) 
: hwnd(hwnd1), hinst(hinst1), surface_width(w), surface_height(h)
{

	unsigned int tid;
	oldRect.left=0;
	oldRect.right=0;
	oldRect.top=0;
	oldRect.bottom=0;
	brun=true;
	bQuit=false;
	bPause=false;
	songTitle=NULL;
	songUsed=NULL;
	done=false;
	bUpdate=false;
	InitializeCriticalSection(&crsec);
	hThread = (HANDLE)_beginthreadex(NULL,0,thefunc,(void *)this,0,&tid);
}

ThreadRender::~ThreadRender()
{
	DeleteCriticalSection(&crsec);
	if (hThread != NULL) CloseHandle(hThread);
	if (songTitle != NULL) delete[] songTitle;
	if (songUsed != NULL) delete[] songUsed;
}

void ThreadRender::Start()
{
	if (bQuit) return;
	if (!brun && hThread != NULL) {
		brun=true;
		ResumeThread(hThread);
	}
	bPause=false;
}

void ThreadRender::Pause()
{
	if (bQuit) return;
//	if (brun && hThread != NULL) {
//		SuspendThread(hThread);
//		brun=false;
//	}
	if (!bPause) {
		EnterCriticalSection(&crsec);
		bPause=true;
		LeaveCriticalSection(&crsec);
	}
}

void ThreadRender::Stop()
{
	if (bQuit) return;
	if (!brun) Start();
	bQuit=true;
	OutputDebugString("Waiting for thread to stop\n");
	WaitForSingleObject(hThread,20000);
#if 0
	if (win_ok != 0) {
		if (win_gl) {
			ptc_gl_close();
		} else {
			ptc_close();
		}
		win_ok=0;
	}
#endif
}

#define s1 128
#define s2 256

void ThreadRender::NewData(TimedLevel *pLevels, HWND hwnd1, int w, int h)
{
	hwnd = hwnd1;
	int i;
	for (i = 0; i < 512; i++) {
		data[0][i] = ((short)pLevels->waveform[0][i]^s1) * s2;
		data[1][i] = ((short)pLevels->waveform[1][i]^s1) * s2;
	}
	surface_width=w;
	surface_height=h;
	levels_state = pLevels->state;
	bUpdate=true;
}

void ThreadRender::NewSong(char *song)
{
	EnterCriticalSection(&crsec);
  	songTitle=song;
	if (songUsed != NULL) {
		delete songUsed;
		songUsed=NULL;
	}
	LeaveCriticalSection(&crsec);
}

bool ThreadRender::IsDone()
{
	return done;
}
