/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashSet;
import org.jrobin.core.RrdBackend;

public class RrdFileBackend
extends RrdBackend {
    static final long LOCK_DELAY = 100L;
    private static HashSet openFiles = new HashSet();
    protected RandomAccessFile file;
    protected FileChannel channel;
    protected FileLock fileLock;

    protected RrdFileBackend(String string, boolean bl, int n) throws IOException {
        super(string);
        this.file = new RandomAccessFile(string, bl ? "r" : "rw");
        this.channel = this.file.getChannel();
        if (!bl) {
            this.lockFile(n);
            RrdFileBackend.registerWriter(string);
        }
    }

    private static synchronized void registerWriter(String string) throws IOException {
        String string2 = RrdFileBackend.getCanonicalPath(string);
        if (openFiles.contains(string2)) {
            throw new IOException("File \"" + string + "\" already open for R/W access. " + "You cannot open the same file for R/W access twice");
        }
        openFiles.add(string2);
    }

    private void lockFile(int n) throws IOException {
        if (n == 1 || n == 2) {
            do {
                this.fileLock = this.channel.tryLock();
                if (this.fileLock != null) continue;
                if (n == 1) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new IOException("Access denied. File [" + this.getPath() + "] already locked");
            } while (this.fileLock == null);
        }
    }

    public void close() throws IOException {
        super.close();
        RrdFileBackend.unregisterWriter(this.getPath());
        this.unlockFile();
        this.channel.close();
        this.file.close();
    }

    private static synchronized void unregisterWriter(String string) throws IOException {
        String string2 = RrdFileBackend.getCanonicalPath(string);
        openFiles.remove(string2);
    }

    private void unlockFile() throws IOException {
        if (this.fileLock != null) {
            this.fileLock.release();
            this.fileLock = null;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public static String getCanonicalPath(String string) throws IOException {
        return new File(string).getCanonicalPath();
    }

    public String getCanonicalPath() throws IOException {
        return RrdFileBackend.getCanonicalPath(this.getPath());
    }

    protected void write(long l, byte[] byArray) throws IOException {
        this.file.seek(l);
        this.file.write(byArray);
    }

    protected void read(long l, byte[] byArray) throws IOException {
        this.file.seek(l);
        if (this.file.read(byArray) != byArray.length) {
            throw new IOException("Not enough bytes available in file " + this.getPath());
        }
    }

    public long getLength() throws IOException {
        return this.file.length();
    }

    protected void setLength(long l) throws IOException {
        this.file.setLength(l);
    }
}

