/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.order;

import java.io.IOException;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.Order;
import org.videolan.vlma.model.StreamChannel;
import org.videolan.vlma.model.StreamingStrategy;
import org.videolan.vlma.order.OrderSender;

public class StreamOrderSender
extends OrderSender {
    public void start(Order o) throws IOException {
        this.telnetConnect(o.getAdapter().getServer());
        for (Media m : o.getMedias()) {
            StreamChannel ch = (StreamChannel)m;
            String commandName = this.getVLMCommandName(o) + ch.getId();
            this.init(commandName, o.getAdapter());
            this.telnetCommand("setup " + commandName + " loop", o.getAdapter());
            this.telnetCommand("setup " + commandName + " option sout-keep", o.getAdapter());
            this.telnetCommand("setup " + commandName + " input \"" + ch.getStreamURL() + "\"", o.getAdapter());
            StringBuilder output = new StringBuilder();
            output.append(String.format("#standard{mux=%s,access=%s,dst=%s", this.getMux(ch.getProgram()), this.getAccess(ch.getProgram()), this.getDst(ch.getProgram())));
            if (ch.getProgram().getStreamingStrategy().isEnabled(StreamingStrategy.Announcement.SAP)) {
                output.append(String.format(",sap,name=\"%s\",group=\"%s\")", ch.getProgram().getSapName(), ch.getProgram().getSapGroup()));
            }
            output.append("}");
            this.telnetCommand("setup " + commandName + " output " + output.toString(), o.getAdapter());
            this.telnetCommand("setup " + commandName + " enabled", o.getAdapter());
            this.telnetCommand("control " + commandName + " play", o.getAdapter());
        }
        this.telnetClose();
    }

    public void stop(Order o) throws IOException {
        this.telnetConnect(o.getAdapter().getServer());
        for (Media m : o.getMedias()) {
            StreamChannel ch = (StreamChannel)m;
            this.stopCommand(this.getVLMCommandName(o) + ch.getId(), o.getAdapter());
        }
        this.telnetClose();
    }
}

