/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.ArcDef;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchPoint;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;

public class FetchRequest {
    private RrdDb parentDb;
    private String consolFun;
    private long fetchStart;
    private long fetchEnd;
    private long resolution;
    private String[] filter;

    FetchRequest(RrdDb rrdDb, String string, long l, long l2, long l3) throws RrdException {
        this.parentDb = rrdDb;
        this.consolFun = string;
        this.fetchStart = l;
        this.fetchEnd = l2;
        this.resolution = l3;
        this.validate();
    }

    public void setFilter(String[] stringArray) {
        this.filter = stringArray;
    }

    public void setFilter(String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        this.filter = stringArray;
    }

    public String[] getFilter() {
        return this.filter;
    }

    public String getConsolFun() {
        return this.consolFun;
    }

    public long getFetchStart() {
        return this.fetchStart;
    }

    public long getFetchEnd() {
        return this.fetchEnd;
    }

    public long getResolution() {
        return this.resolution;
    }

    private void validate() throws RrdException {
        if (!ArcDef.isValidConsolFun(this.consolFun)) {
            throw new RrdException("Invalid consolidation function in fetch request: " + this.consolFun);
        }
        if (this.fetchStart < 0L) {
            throw new RrdException("Invalid start time in fetch request: " + this.fetchStart);
        }
        if (this.fetchEnd < 0L) {
            throw new RrdException("Invalid end time in fetch request: " + this.fetchEnd);
        }
        if (this.fetchStart > this.fetchEnd) {
            throw new RrdException("Invalid start/end time in fetch request: " + this.fetchStart + " > " + this.fetchEnd);
        }
        if (this.resolution <= 0L) {
            throw new RrdException("Invalid resolution in fetch request: " + this.resolution);
        }
    }

    public String dump() {
        return "fetch \"" + this.parentDb.getRrdBackend().getPath() + "\" " + this.consolFun + " --start " + this.fetchStart + " --end " + this.fetchEnd + (this.resolution > 1L ? " --resolution " + this.resolution : "");
    }

    String getRrdToolCommand() {
        return this.dump();
    }

    public FetchPoint[] fetch() throws RrdException, IOException {
        return this.parentDb.fetch(this);
    }

    public FetchData fetchData() throws RrdException, IOException {
        return this.parentDb.fetchData(this);
    }

    public RrdDb getParentDb() {
        return this.parentDb;
    }
}

