/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.IOException;
import org.jrobin.core.ArcDef;
import org.jrobin.core.Archive;
import org.jrobin.core.Datasource;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

public class RrdToolkit {
    private static RrdToolkit ourInstance;

    public static synchronized RrdToolkit getInstance() {
        if (ourInstance == null) {
            ourInstance = new RrdToolkit();
        }
        return ourInstance;
    }

    private RrdToolkit() {
    }

    public void addDatasource(String string, String string2, DsDef dsDef) throws IOException, RrdException {
        if (Util.sameFilePath(string, string2)) {
            throw new RrdException("Source and destination paths are the same");
        }
        RrdDb rrdDb = new RrdDb(string);
        RrdDef rrdDef = rrdDb.getRrdDef();
        rrdDef.setPath(string2);
        rrdDef.addDatasource(dsDef);
        RrdDb rrdDb2 = new RrdDb(rrdDef);
        rrdDb.copyStateTo(rrdDb2);
        rrdDb.close();
        rrdDb2.close();
    }

    public void addDatasource(String string, DsDef dsDef, boolean bl) throws IOException, RrdException {
        String string2 = Util.getTmpFilename();
        this.addDatasource(string, string2, dsDef);
        RrdToolkit.copyFile(string2, string, bl);
    }

    public void removeDatasource(String string, String string2, String string3) throws IOException, RrdException {
        if (Util.sameFilePath(string, string2)) {
            throw new RrdException("Source and destination paths are the same");
        }
        RrdDb rrdDb = new RrdDb(string);
        RrdDef rrdDef = rrdDb.getRrdDef();
        rrdDef.setPath(string2);
        rrdDef.removeDatasource(string3);
        RrdDb rrdDb2 = new RrdDb(rrdDef);
        rrdDb.copyStateTo(rrdDb2);
        rrdDb.close();
        rrdDb2.close();
    }

    public void removeDatasource(String string, String string2, boolean bl) throws IOException, RrdException {
        String string3 = Util.getTmpFilename();
        this.removeDatasource(string, string3, string2);
        RrdToolkit.copyFile(string3, string, bl);
    }

    public void addArchive(String string, String string2, ArcDef arcDef) throws IOException, RrdException {
        if (Util.sameFilePath(string, string2)) {
            throw new RrdException("Source and destination paths are the same");
        }
        RrdDb rrdDb = new RrdDb(string);
        RrdDef rrdDef = rrdDb.getRrdDef();
        rrdDef.setPath(string2);
        rrdDef.addArchive(arcDef);
        RrdDb rrdDb2 = new RrdDb(rrdDef);
        rrdDb.copyStateTo(rrdDb2);
        rrdDb.close();
        rrdDb2.close();
    }

    public void addArchive(String string, ArcDef arcDef, boolean bl) throws IOException, RrdException {
        String string2 = Util.getTmpFilename();
        this.addArchive(string, string2, arcDef);
        RrdToolkit.copyFile(string2, string, bl);
    }

    public void removeArchive(String string, String string2, String string3, int n) throws IOException, RrdException {
        if (Util.sameFilePath(string, string2)) {
            throw new RrdException("Source and destination paths are the same");
        }
        RrdDb rrdDb = new RrdDb(string);
        RrdDef rrdDef = rrdDb.getRrdDef();
        rrdDef.setPath(string2);
        rrdDef.removeArchive(string3, n);
        RrdDb rrdDb2 = new RrdDb(rrdDef);
        rrdDb.copyStateTo(rrdDb2);
        rrdDb.close();
        rrdDb2.close();
    }

    public void removeArchive(String string, String string2, int n, boolean bl) throws IOException, RrdException {
        String string3 = Util.getTmpFilename();
        this.removeArchive(string, string3, string2, n);
        RrdToolkit.copyFile(string3, string, bl);
    }

    private static void copyFile(String string, String string2, boolean bl) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        if (bl) {
            String string3 = RrdToolkit.getBackupPath(string2);
            File file3 = new File(string3);
            RrdToolkit.deleteFile(file3);
            if (!file2.renameTo(file3)) {
                throw new IOException("Could not create backup file " + string3);
            }
        }
        RrdToolkit.deleteFile(file2);
        if (!file.renameTo(file2)) {
            throw new IOException("Could not create file " + string2 + " from " + string);
        }
    }

    private static String getBackupPath(String string) {
        String string2 = string;
        while (new File(string2 = string2 + ".bak").exists()) {
        }
        return string2;
    }

    public void setDsHeartbeat(String string, String string2, long l) throws RrdException, IOException {
        RrdDb rrdDb = new RrdDb(string);
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setHeartbeat(l);
        rrdDb.close();
    }

    public void setDsMinValue(String string, String string2, double d, boolean bl) throws RrdException, IOException {
        RrdDb rrdDb = new RrdDb(string);
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setMinValue(d, bl);
        rrdDb.close();
    }

    public void setDsMaxValue(String string, String string2, double d, boolean bl) throws RrdException, IOException {
        RrdDb rrdDb = new RrdDb(string);
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setMaxValue(d, bl);
        rrdDb.close();
    }

    public void setDsMinMaxValue(String string, String string2, double d, double d2, boolean bl) throws RrdException, IOException {
        RrdDb rrdDb = new RrdDb(string);
        Datasource datasource = rrdDb.getDatasource(string2);
        datasource.setMinMaxValue(d, d2, bl);
        rrdDb.close();
    }

    public void setArcXff(String string, String string2, int n, double d) throws RrdException, IOException {
        RrdDb rrdDb = new RrdDb(string);
        Archive archive = rrdDb.getArchive(string2, n);
        archive.setXff(d);
        rrdDb.close();
    }

    public void resizeArchive(String string, String string2, String string3, int n, int n2) throws IOException, RrdException {
        if (Util.sameFilePath(string, string2)) {
            throw new RrdException("Source and destination paths are the same");
        }
        if (n2 < 2) {
            throw new RrdException("New arcihve size must be at least 2");
        }
        RrdDb rrdDb = new RrdDb(string);
        RrdDef rrdDef = rrdDb.getRrdDef();
        ArcDef arcDef = rrdDef.findArchive(string3, n);
        if (arcDef.getRows() != n2) {
            arcDef.setRows(n2);
            rrdDef.setPath(string2);
            RrdDb rrdDb2 = new RrdDb(rrdDef);
            rrdDb.copyStateTo(rrdDb2);
            rrdDb2.close();
        }
        rrdDb.close();
    }

    public void resizeArchive(String string, String string2, int n, int n2, boolean bl) throws IOException, RrdException {
        String string3 = Util.getTmpFilename();
        this.resizeArchive(string, string3, string2, n, n2);
        RrdToolkit.copyFile(string3, string, bl);
    }

    private static void deleteFile(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file: " + file.getCanonicalPath());
        }
    }
}

