/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.model;

import java.io.Serializable;

/**
 * A media.
 *
 * @author Sylvain Cadilhac <sylv at videolan.org>
 */
public abstract class Media implements Serializable {

    private Integer id;

    protected String name;

    protected Program program;

    /**
     * Gets the Media ID.
     *
     * @return the id
     */
    public Integer getId() {
        return id;
    }

    /**
     * Sets the media ID.
     *
     * @param id the id to set
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * Gives the program associated with the media.
     *
     * @return the program
     */
    public Program getProgram() {
        return program;
    }

    /**
     * Sets the program associated with the media.
     *
     * @param program the program to set
     */
    public void setProgram(Program program) {
        this.program = program;
    }

    /**
     * Sets the media name.
     *
     * @param name the media name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Gives the media name.
     *
     * @return the media name
     */
    public String getName() {
        return name;
    }

    /**
     * Gets the media type.
     *
     * @return the media type
     */
    abstract public String getType();

    /**
     * Returns true if and only if the given media belongs to the same group.
     *
     * @param media the media to compare to
     * @return true if both media belong to the same group, false otherwise
     */
    public boolean sameGroup(Media media) {
        return false;
    }

    /**
     * Returns true if and only if the media belongs to the given media group.
     *
     * @param group the group
     * @return true if the media belongs to the group, false otherwise
     */
    public boolean belongsToGroup(MediaGroup group) {
        if (group == null || group.isEmpty()) {
            return false;
        }
        return sameGroup(group.get(0));
    }
}
